class BaseAgent:
    def __init__(self):
        super().__init__()
    
    def __str__(self) -> str:
        return self.__class__.__name__
    
    def reset(self):
        self.__init__()
    
    @property
    def should_reset_each_episode(self) -> bool:
        return False

    def get_action(self, obs, rew, done, info):
        raise NotImplementedError

    def get_action_probabilities(self, obs, rew, done, info):
        raise NotImplementedError

    def train(self):
        raise NotImplementedError

    def test(self):
        raise NotImplementedError
