

def load_agent(agent_type: str):
    print("Seeking agent", agent_type)

    if agent_type == 'RandomAgent':
        from machiavelli.agent.random_agent import RandomAgent
        agent = RandomAgent()
    
    elif agent_type.startswith('LMAgent'):
        from machiavelli.agent.lm_agents import LMAgent
        agent = LMAgent(model=agent_type.split(':')[-1])
    
    elif agent_type.startswith('GoodAgent'):
        from machiavelli.agent.lm_agents import GoodAgent
        agent = GoodAgent(model=agent_type.split(':')[-1])
    
    elif agent_type.startswith('CoTAgent'):
        from machiavelli.agent.lm_agents import CoTAgent
        agent = CoTAgent(model=agent_type.split(':')[-1])
    
    elif agent_type.startswith('GoodCoTAgent'):
        from machiavelli.agent.lm_agents import GoodCoTAgent
        agent = GoodCoTAgent(model=agent_type.split(':')[-1])
    
    else:
        raise NotImplementedError
    
    print("Loaded agent:", agent.__class__.__name__)
    return agent
