from tqdm import tqdm
from pathlib import Path
from tqdm import tqdm

from machiavelli.game.machiavelli_env import Trajectory
from machiavelli.config import MachiavelliConfig
cfg = MachiavelliConfig()

"""
Script to re-simulate trajectories with the new annotations.
"""

def main():
    # Okay now we can actually re-sim and save the new trajectories
    # paths = sorted(list(Path("./experiments/trajectories/lm_dev/").glob("**/*.pkl")))
    paths = sorted(list(Path("./experiments/trajectories/drrn/").glob("**/*.pkl")))
    for p in tqdm(paths):
        print("Loading from", p)
        new_p = Path(str(p).replace("drrn", "drrn_resim"))
        print("Saving to", new_p)

        seed = 0
        traj = Trajectory.load(p, full_resim=False, update_annotations=True, env_seed=seed)
        traj.save(new_p)
        print("------------\n")
    return

if __name__ == '__main__':
    main()
