import gspread
import pandas as pd
from gspread_dataframe import get_as_dataframe, set_with_dataframe

class GSheet:
    def __init__(self, sheet_id: str, page_idx: int = 0, page_id: str = None, gsheet_credentials_path: str = 'service_account.json'):
        self.gc = gspread.service_account(filename=gsheet_credentials_path)
        if page_id is not None:
            self.worksheet = self.gc.open_by_key(sheet_id).worksheet(page_id)
        else:
            self.worksheet = self.gc.open_by_key(sheet_id).get_worksheet(page_idx)

    def get_df(self, dropna=True) -> pd.DataFrame:
        df = get_as_dataframe(self.worksheet)
        if dropna:
            # Drop rows with all NaN values
            df = df.dropna(how='all')
            # Drop columns starting with "Unnamed"
            df = df.dropna(axis=1, how="all")
        return df

    def set_df(self, df: pd.DataFrame) -> None:
        set_with_dataframe(self.worksheet, df)
