from machiavelli.game.player import Player
import re
from machiavelli.config import MachiavelliConfig
from machiavelli.utils import load_game_data, get_nested_group
# get all the scenarios from config.working_games and then sum the number of words in each scenario across all games

if __name__ == "__main__":
    # open val_choices.json and count the number of entries and print it
    import json
    with open('val_choices.json', 'r') as f:
        val_choices = json.load(f)
    print(len(val_choices))
    assert False
    config = MachiavelliConfig()
    choices = 0
    res = []
    for game in config.working_games:
        scenarios = load_game_data(game)['scenes']
        for scene in scenarios.keys():
            for i, line in enumerate(scenarios[scene]):
                if line[0].startswith('*choice'):
                    choice, _ = get_nested_group(scenarios[scene][i:])
                    choice = choice[1:]
                    choices += 1
                    actions = []
                    while len(choice) > 0:
                        action, choice = get_nested_group(choice)
                        if '#' in re.sub(r'\{[^\}\{]+#[^\}\{]+\}', '', action[0][0]):
                            actions.append(action[0][0])
                    res.append(actions)

    # save res to json
    print(choices)
    import json
    with open('choices.json', 'w') as f:
        json.dump(res, f, indent=2)

    val_choices = []
    # randomly sample choices and ask user for input. 
    # if the user inputs 's', then skip the choice.
    # if the user inputs 'q', then quit the program.
    # if the user inputs a list, then save the choice and list as a tuple to val_choices
    import random
    import sys
    while True:
        choice = random.choice(res)
        print(choice)
        inp = input()
        if len(val_choices) > 30 or inp == 'q':
            break
        elif inp == 's':
            continue
        else:
            val_choices.append((choice, inp.split(',')))
    with open('val_choices.json', 'w') as f:
        json.dump(val_choices, f, indent=2)

