
### BIOS BIAS DATASET, GENDER STEERING ###

# gender steering on GPT2-XL for the profession_sample_250 dataset with online (unsupervised) abstraction
python -m abstract_cf.text_generation.abstract_counterfactual \
    --dataset_name profession_sample_250 \
    --batch_size 50 \
    --n_samples_per_generation 150 \
    --n_posterior_cf_samples 30 \
    --argmax_observation \
    --factual_model_name openai-community/gpt2-xl \
    --intervention_config intervention_configs/gender_steering_gpt2-xl.yaml \
    --abstraction_type online


# gender steering on GPT2-XL for the profession_sample_250 dataset with supervised abstraction  
python -m abstract_cf.text_generation.abstract_counterfactual \
    --dataset_name profession_sample_250 \
    --batch_size 50 \
    --n_samples_per_generation 150 \
    --n_posterior_cf_samples 30 \
    --argmax_observation \
    --factual_model_name openai-community/gpt2-xl \
    --intervention_config intervention_configs/gender_steering_gpt2-xl.yaml \
    --abstraction_type offline \
    --offline_abstraction_checkpoint model_data/learned_abstractions/profession/checkpoint-5994



### GOEMOTIONS DATASET, TOKEN LEVEL REPLACEMENT ###

# token level replacement GPT2-XL for the emotion_sample_250 dataset with online (unsupervised) abstraction
python -m abstract_cf.text_generation.abstract_counterfactual \
    --dataset_name emotion_sample_250 \
    --batch_size 50 \
    --n_samples_per_generation 150 \
    --n_posterior_cf_samples 30 \
    --argmax_observation \
    --factual_model_name openai-community/gpt2-xl \
    --intervention_config intervention_configs/goemotions_token_replacement_gpt2-xl.yaml \
    --abstraction_type online


# token level replacement GPT2-XL for the emotion_sample_250 dataset with supervised abstraction  
python -m abstract_cf.text_generation.abstract_counterfactual \
    --dataset_name emotion_sample_250 \
    --batch_size 50 \
    --n_samples_per_generation 150 \
    --n_posterior_cf_samples 30 \
    --argmax_observation \
    --factual_model_name openai-community/gpt2-xl \
    --intervention_config intervention_configs/goemotions_token_replacement_gpt2-xl.yaml \
    --abstraction_type offline \
    --offline_abstraction_checkpoint model_data/learned_abstractions/emotion/checkpoint-568


# token level replacement Llama3.2-1B for the emotion_sample_250 dataset with online (unsupervised) abstraction
python -m abstract_cf.text_generation.abstract_counterfactual \
    --dataset_name emotion_sample_250 \
    --batch_size 50 \
    --n_samples_per_generation 150 \
    --n_posterior_cf_samples 30 \
    --argmax_observation \
    --factual_model_name meta-llama/Llama-3.2-1B \
    --intervention_config intervention_configs/goemotions_token_replacement_llama3.2.yaml \
    --abstraction_type online


# token level replacement Llama3.2-1B for the emotion_sample_250 dataset with supervised abstraction  
python -m abstract_cf.text_generation.abstract_counterfactual \
    --dataset_name emotion_sample_250 \
    --batch_size 50 \
    --n_samples_per_generation 150 \
    --n_posterior_cf_samples 30 \
    --argmax_observation \
    --factual_model_name meta-llama/Llama-3.2-1B \
    --intervention_config intervention_configs/goemotions_token_replacement_llama3.2.yaml \
    --abstraction_type offline \
    --offline_abstraction_checkpoint model_data/learned_abstractions/emotion/checkpoint-568



