import json
import openai
import pandas as pd
import numpy as np
import csv
from pathlib import Path
from machiavelli.openai_helpers import completion_with_retries

model = "text-alpha-002-latest" # XYZ
temperature = 0.7
max_tokens = 4096

outpath = Path("power_examples_2.json")
out_obj = {}
if outpath.exists():
    with open(outpath) as f:
        out_obj = json.load(f)

INSPIRATION = [
    ["actor", "animal rescue worker", "animal trainer", "antiques dealer", "architect", "auto mechanic", "babysitter", "barista", "bartender", "bouncer", "bounty hunter", "business tycoon", "cashier", "chef", "clergy member", "conductor", "coroner", "corrections officer (prison guard)", "deep sea diver (commercial)", "detective", "diplomat", "dog groomer", "driver (car)", "emergency dispatcher", "emergency room physician", "escort", "ethical hacker", "exotic dancer", "farmer", "fundraiser", "funeral director", "general contractor", "geologist", "ghostwriter", "glassblower", "home health aide", "human test subject", "interpreter", "jeweler", "landscape designer", "lawyer", "librarian", "locksmith", "mail carrier", "makeup artist", "massage therapist", "mechanical engineer", "midwife", "model", "nanny", "nurse (rn)", "outdoor guide", "painter", "paleontologist", "paralegal", "parole officer", "personal assistant to a celebrity", "personal trainer", "pest control technician", "pharmacist", "photographer", "physical therapist", "pilot", "police officer", "professional athlete", "professor", "radio dj", "rancher", "realtor", "recruiter", "referee", "security guard", "server", "skydiving instructor", "small business owner", "tattoo artist", "taxidermist", "teacher", "therapist (mental health)", "tour guide", "treasure hunter", "veterinarian", "wedding planner", "yoga instructor", 'anesthesiologists', 'obstetricians and gynecologists', 'oral and maxillofacial surgeons', 'orthodontists', 'psychiatrists', 'surgeons', 'family and general practitioners', 'physicians and surgeons, all other', 'internists, general', 'chief executives', 'prosthodontists', 'pediatricians, general', 'nurse anesthetists', 'dentists, general', 'dentists, all other specialists', 'computer and information systems managers', 'architectural and engineering managers', 'airline pilots, copilots, and flight engineers', 'petroleum engineers', 'marketing managers', 'judges, magistrate judges, and magistrates', 'podiatrists', 'financial managers', 'pharmacists', 'air traffic controllers', 'sales managers', 'natural sciences managers', 'compensation and benefits managers', 'physicists', 'lawyers', 'purchasing managers', 'computer and information research scientists', 'political scientists', 'advertising and promotions managers', 'aerospace engineers', 'public relations and fundraising managers', 'computer hardware engineers', 'human resources managers', 'optometrists', 'training and development managers', 'law teachers, postsecondary', 'software developers, systems software', 'computer network architects', 'physician assistants', 'nuclear engineers', 'managers, all other', 'physical scientists, all other', 'nurse practitioners', 'astronomers', 'chemical engineers', 'economists', 'nurse midwives', 'software developers, applications', 'industrial production managers', 'actuaries', 'electronics engineers, except computer', 'mathematicians', 'engineering teachers, postsecondary', 'economics teachers, postsecondary', 'sales engineers', 'general and operations managers', 'psychologists, all other', 'administrative law judges, adjudicators, and hearing officers', 'materials scientists', 'medical and health services managers', 'information security analysts', 'health specialties teachers, postsecondary', 'industrial-organizational psychologists', 'engineers, all other', 'electrical engineers', 'administrative services managers', 'education administrators, elementary and secondary school', 'transportation, storage, and distribution managers', 'education administrators, postsecondary', 'nuclear power reactor operators', 'atmospheric and space scientists', 'veterinarians', 'construction managers', 'biochemists and biophysicists', 'art directors', 'marine engineers and naval architects', 'materials engineers', 'mining and geological engineers, including mining safety engineers', 'geoscientists, except hydrologists and geographers', 'atmospheric, earth, marine, and space sciences teachers, postsecondary', 'physics teachers, postsecondary', 'computer occupations, all other', 'database administrators', 'health and safety engineers, except mining safety engineers and inspectors', 'first-line supervisors of police and detectives', 'personal financial advisors', 'computer systems analysts', 'biomedical engineers', 'physical therapists', 'statisticians', 'environmental engineers', 'mechanical engineers', 'architecture teachers, postsecondary', 'industrial engineers', 'forestry and conservation science teachers, postsecondary', 'civil engineers', 'power distributors and dispatchers', 'financial analysts', 'medical scientists, except epidemiologists', 'agricultural sciences teachers, postsecondary', 'computer programmers', 'occupational therapists', 'business teachers, postsecondary', 'anthropology and archeology teachers, postsecondary', 'management analysts', 'operations research analysts', 'political science teachers, postsecondary', 'education administrators, all other', 'biological science teachers, postsecondary', 'radiation therapists', 'commercial pilots', 'computer science teachers, postsecondary', 'network and computer systems administrators', 'sociologists', 'detectives and criminal investigators', 'social scientists and related workers, all other', 'genetic counselors', 'geography teachers, postsecondary', 'geographers', 'electrical and electronics repairers, powerhouse, substation, and relay', 'financial examiners', 'environmental science teachers, postsecondary', 'elevator installers and repairers', 'sales representatives, wholesale and manufacturing, technical and scientific products', 'biological scientists, all other', 'chemistry teachers, postsecondary', 'media and communication equipment workers, all other', 'power plant operators', 'architects, except landscape and naval', 'hydrologists', 'funeral service managers', 'nuclear technicians', 'life scientists, all other', 'speech-language pathologists', 'agricultural engineers', 'clinical, counseling, and school psychologists', 'chemists', 'nuclear medicine technologists', 'psychology teachers, postsecondary', 'first-line supervisors of fire fighting and prevention workers', 'budget analysts', 'postmasters and mail superintendents', 'audiologists', 'dental hygienists', 'gaming managers', 'history teachers, postsecondary', 'logisticians', 'area, ethnic, and cultural studies teachers, postsecondary', 'emergency management directors', 'sociology teachers, postsecondary', 'health diagnosing and treating practitioners, all other', 'transit and railroad police', 'transportation inspectors', 'nursing instructors and teachers, postsecondary', 'first-line supervisors of non-retail sales workers', 'mathematical science teachers, postsecondary', 'occupational health and safety specialists', 'urban and regional planners', 'fashion designers', 'diagnostic medical sonographers', 'multimedia artists and animators', 'philosophy and religion teachers, postsecondary', 'technical writers', 'magnetic resonance imaging technologists', 'microbiologists', 'producers and directors', 'registered nurses', 'library science teachers, postsecondary', 'social sciences teachers, postsecondary, all other', 'credit analysts', 'chiropractors', 'home economics teachers, postsecondary', 'environmental scientists and specialists, including health', 'gas plant operators', 'ship engineers', 'electrical power-line installers and repairers', 'petroleum pump system operators, refinery operators, and gaugers', 'accountants and auditors', 'business operations specialists, all other', 'signal and track switch repairers', 'financial specialists, all other', 'art, drama, and music teachers, postsecondary', 'epidemiologists', 'insurance underwriters', 'web developers', 'captains, mates, and pilots of water vessels', 'orthotists and prosthetists', 'communications teachers, postsecondary', 'compliance officers', 'social work teachers, postsecondary', 'landscape architects', 'subway and streetcar operators', 'farmers, ranchers, and other agricultural managers', 'labor relations specialists', 'foreign language and literature teachers, postsecondary', 'aerospace engineering and operations technicians', 'broadcast news analysts', 'commercial and industrial designers', 'english language and literature teachers, postsecondary', 'first-line supervisors of mechanics, installers, and repairers', 'agents and business managers of artists, performers, and athletes', 'claims adjusters, examiners, and investigators', 'postsecondary teachers, all other', 'artists and related workers, all other', 'food scientists and technologists', 'social and community service managers', 'gas compressor and gas pumping station operators', 'supervisors of construction and extraction workers', 'education teachers, postsecondary', 'cartographers and photogrammetrists', 'instructional coordinators', 'electrical and electronic engineering technicians', 'makeup artists, theatrical and performance', 'avionics technicians', 'securities, commodities, and financial services sales agents', 'cost estimators', 'soil and plant scientists', 'locomotive firers', 'zoologists and wildlife biologists', 'first-line supervisors of correctional officers', 'engineering technicians, except drafters, all other', 'market research analysts and marketing specialists', 'social workers, all other', 'compensation, benefits, and job analysis specialists', 'loan officers', 'aircraft mechanics and service technicians', 'railroad conductors and yardmasters', 'buyers and purchasing agents', 'computer network support specialists', 'film and video editors', 'recreation and fitness studies teachers, postsecondary', 'surveyors', 'fire inspectors and investigators', 
    'insurance appraisers, auto damage', 'anthropologists and archeologists', 'arbitrators, mediators, and conciliators', 'boilermakers', 'writers and authors', 'chemical plant and system operators', 
    'locomotive engineers', 'criminal justice and law enforcement teachers, postsecondary', 'foresters', "police and sheriff's patrol officers", 'conservation scientists', 'historians', 'human resources specialists', 'patternmakers, wood', 'training and development specialists', 'designers, all other', 'special education teachers, secondary school', 'dietitians and nutritionists', 'first-line supervisors of production and operating workers', 'stationary engineers and boiler operators', 'career/technical education teachers, secondary school', 'electrical and electronics installers and repairers, transportation equipment', 'respiratory therapists', 'secondary school teachers, except special and career/technical education', 'special education teachers, middle school', 'occupational therapy assistants', 'electrical and electronics drafters', 'public relations specialists', 'construction and building inspectors', 'editors', 'radiologic technologists', 'special education teachers, kindergarten and elementary school', 'executive secretaries and executive administrative assistants', 'career/technical education teachers, middle school', 'librarians', 'legal support workers, all other', 'postal service mail sorters, processors, and processing machine operators', 'pile-driver operators', 'roof bolters, mining', 'middle school teachers, except special and career/technical education', 'musicians and singers', 'sales representatives, wholesale and manufacturing, except technical and scientific products', 'animal scientists', 'property, real estate, and community association managers', 'telecommunications line installers and repairers', 'elementary school teachers, except special education', 'forensic science technicians', 'real estate brokers', 'electrical and electronics repairers, commercial and industrial equipment', 'physical therapist assistants', 'electro-mechanical technicians', 'fish and game wardens', 'survey researchers', 'precision instrument and equipment repairers, all other', 'railroad brake, signal, and switch operators', 'court reporters', 'miscellaneous mathematical science occupations', 'plant and system operators, all other', 'fundraisers', 'rail-track laying and maintenance equipment operators', 'cardiovascular technologists and technicians', 'special education teachers, all other', 'educational, guidance, school, and vocational counselors', 'mine shuttle car operators', 'healthcare social workers', 'mechanical engineering technicians', 'rail car repairers', 'control and valve installers and repairers, except mechanical door', 'model makers, metal and plastic', 'telecommunications equipment installers and repairers, except line installers', 'flight attendants', 'mechanical drafters', 'first-line supervisors of office and administrative support workers', 'special education teachers, preschool', 'first-line supervisors of transportation and material moving workers, except aircraft cargo handling supervisors', 'industrial engineering technicians', 'kindergarten teachers, except special education', 'rail transportation workers, all other', 'postal service clerks', 'electricians', 'postal service mail carriers', 'millwrights', 'tapers', 'appraisers and assessors of real estate', 'architectural and civil drafters', 'radio, cellular, and tower equipment installers and repairers', 'extraction workers, all other', 'camera operators, television, video, and motion picture', 'healthcare practitioners and technical workers, all other', 'sales representatives, services, all other', 'continuous mining machine operators', 'tax examiners and collectors, and revenue agents', 'wind turbine service technicians', 'set and exhibit designers', 'food service managers', 'health educators', 'crane and tower operators', 'structural iron and steel workers', 'plumbers, pipefitters, and steamfitters', 'curators', 'rotary drill operators, oil and gas', 'adult basic and secondary education and literacy teachers and instructors', 'judicial law clerks', 'wellhead pumpers', 'interior designers', 'lodging managers', 'aircraft structure, surfaces, rigging, and systems assemblers', 'geological and petroleum technicians', 'computer numerically controlled machine tool programmers, metal and plastic', 'model makers, wood', 'vocational education teachers, postsecondary', 'probation officers and correctional treatment specialists', 'hearing aid specialists', 'tool and die makers', 'civil engineering technicians', 'morticians, undertakers, and funeral directors', 'rail yard engineers, dinkey operators, and hostlers', 'sound engineering technicians', 'clinical laboratory technologists and technicians', 'industrial machinery mechanics', 'airfield operations specialists', 'archivists', 'refractory materials repairers, except brickmasons', 'drafters, all other', 'mobile heavy equipment mechanics, except engines', 'advertising sales agents', 'mining machine operators, all other', 'brokerage clerks', 'loading machine operators, underground mining', 'respiratory therapy technicians', 'computer user support specialists', 'therapists, all other', 'brickmasons and blockmasons', 'paralegals and legal assistants', 'occupational health and safety technicians', 'athletes and sports competitors', 'environmental engineering technicians', 'insurance sales agents', 'graphic designers', 'riggers', 'bridge and lock tenders', 'motorboat operators', 'marriage and family therapists', 'private detectives and investigators', 'explosives workers, ordnance handling experts, and blasters', 'interpreters and translators', 'farm and home management advisors', 'life, physical, and social science technicians, all other', 'audio-visual and multimedia collections specialists', 'firefighters', 'first-line supervisors of protective service workers, all other', 'music directors and composers', 'fine artists, including painters, sculptors, and illustrators', 'first-line supervisors of gaming workers', 'meeting, convention, and event planners', 'exercise physiologists', 'commercial divers', 'medical equipment repairers', 'clergy', 'chemical equipment operators and tenders', 'real estate sales agents', 'aircraft cargo handling supervisors', 'chefs and head cooks', 'sheet metal workers', 'media and communication workers, all other', 'reinforcing iron and rebar workers', 'statistical assistants', 'chemical technicians', 'first-line supervisors of landscaping, lawn service, and groundskeeping workers', 'education administrators, preschool and childcare center/program', 'layout workers, metal and plastic', 'recreational therapists', 'service unit operators, oil, gas, and mining', 'choreographers', 'operating engineers and other construction equipment operators', 'insulation workers, mechanical', 'heating, air conditioning, and refrigeration mechanics and installers', 'production, planning, and expediting clerks', 'athletic trainers', 'bus and truck mechanics and diesel engine specialists', 'surgical technologists', 'mine cutting and channeling machine operators', 'security and fire alarm systems installers', 'maintenance workers, machinery', 'title examiners, abstractors, and searchers', 'first-line supervisors of farming, fishing, and forestry workers', 'water and wastewater treatment plant and system operators', 'carpenters', 'social science research assistants', 'tire builders', 'traffic technicians', 'legal secretaries', 'child, family, and school social workers', 'environmental science and protection technicians, including health', 'farm labor contractors', 'licensed practical and licensed vocational nurses', 'derrick operators, oil and gas', 'eligibility interviewers, government programs', 'bailiffs', 'computer operators', 'patternmakers, metal and plastic', 'hoist and winch operators', 'dredge operators', 'credit counselors', 'payroll and timekeeping clerks', 'mental health and substance abuse social workers', 'substance abuse, behavioral disorder, and mental health counselors', 'biological technicians', 'earth drillers, except oil and gas', 'engine and other machine assemblers', 'pump operators, except wellhead pumpers', 'surveying and mapping technicians', 'correctional officers and jailers', 'excavating and loading machine and dragline operators', 'embalmers', 'agricultural inspectors', 'fallers', 'audio and video equipment technicians', 'drywall and ceiling tile installers', 'heavy and tractor-trailer truck drivers', 'glaziers', 'machinists', 'milling and planing machine setters, operators, and tenders, metal and plastic', 'plasterers and stucco masons', 'cargo and freight agents', 'cement masons and concrete finishers', 'museum technicians and conservators', 'desktop publishers', 'health technologists and technicians, all other', 'electric motor, power tool, and related repairers', 'floor layers, except carpet, wood, and hard tiles', 'automotive body and related repairers', 'procurement clerks', 'solar photovoltaic installers', 'community and social service specialists, all other', 'terrazzo workers and finishers', 'painters, transportation equipment', 'radio operators', 'bus drivers, transit and intercity', 'counselors, all other', 'education, training, and library workers, all other', 'hazardous materials removal workers', 'tile and marble setters', 'locksmiths and safe repairers', 'transportation security screeners', 'massage therapists', 'welders, cutters, solderers, and brazers', 'reporters and correspondents', 'costume attendants', 'metal-refining furnace operators and tenders', 'stonemasons', 'communications equipment operators, all other', 'financial clerks, all other', 'information and record clerks, all other', 'mechanical door repairers', 'agricultural and food science technicians', 
    'sailors and marine oilers', 'directors, religious activities and education', 'separating, filtering, clarifying, precipitating, and still machine setters, operators, and tenders', 'automotive service technicians and mechanics', 'police, fire, and ambulance dispatchers', 'camera and photographic equipment repairers', 'fabric and apparel patternmakers', 'farm equipment mechanics and service technicians', 'logging equipment operators', 'dental laboratory technicians', 'human resources assistants, except payroll and timekeeping', 'medical records and health information technicians', 'meter readers, utilities', 'prepress technician and workers', 'bookkeeping, accounting, and auditing clerks', 'motorboat mechanics and service technicians', 'broadcast technicians', 'computer-controlled machine tool operators, metal and plastic', 'roofers', 'first-line supervisors of housekeeping and janitorial workers', 'loan interviewers and clerks', 'watch repairers', 'fitness trainers and aerobics instructors', 'parking enforcement workers', 'paving, surfacing, and tamping equipment operators', 'highway maintenance workers', 'insurance claims and policy processing clerks', 'logging workers, all other', 'word processors and typists', 'first-line supervisors of retail sales workers', 'forest fire inspectors and prevention specialists', 'community health workers', 'dispatchers, except police, fire, and ambulance', 'carpet installers', 'jewelers and precious stone and metal workers', 'tax preparers', 'home appliance repairers', 'installation, maintenance, and repair workers, all other', 'structural metal fabricators and fitters', 'furnace, kiln, oven, drier, and kettle operators and tenders', 'lathe and turning machine tool setters, operators, and tenders, metal and plastic', 'medical appliance technicians', 'proofreaders and copy markers', 'septic tank servicers and sewer pipe cleaners', 'forging machine setters, operators, and tenders, metal and plastic', 'miscellaneous construction and related workers', 'painters, construction and maintenance', 'credit authorizers, checkers, and clerks', 'dental assistants', 'paper goods machine setters, operators, and tenders', 'self-enrichment education teachers', 'travel agents', 'pipelayers', 'rolling machine setters, operators, and tenders, metal and plastic', 'computer, automated teller, and office machine repairers', 'insulation workers, floor, ceiling, and wall', 'court, municipal, and license clerks', 'first-line supervisors of personal service workers', 'inspectors, testers, sorters, samplers, and weighers', 'maintenance and repair workers, general', 'electronic home entertainment equipment installers and repairers', 'log graders and scalers', 'recreational vehicle service technicians', 'tank car, truck, and ship loaders', 'tree trimmers and pruners', 'paperhangers', 'tool grinders, filers, and sharpeners', 'drilling and boring machine tool setters, operators, and tenders, metal and plastic', 'billing and posting clerks', 'healthcare support workers, all other', 'pourers and casters, metal', 'welding, soldering, and brazing machine setters, operators, and tenders', 'cooks, private household', 'roustabouts, oil and gas', 'floor sanders and finishers', 'heat treating equipment setters, operators, and tenders, metal and plastic', 'transportation workers, all other', 'correspondence clerks', 'refuse and recyclable material collectors', 'semiconductor processors', 'telephone operators', 'forest and conservation technicians', 'mixing and blending machine setters, operators, and tenders', 'reservation and transportation ticket agents and travel clerks', 'animal breeders', 'opticians, dispensing', 'motorcycle mechanics', 'secretaries and administrative assistants, except legal, medical, and executive', 'actors', 'ophthalmic medical technicians', 'crushing, grinding, and polishing machine setters, operators, and tenders', 'helpers--extraction workers', 'animal control workers', 'musical instrument repairers and tuners', 'medical equipment preparers', 'printing press operators', 'bill and account collectors', 'metal workers and plastic workers, all other', 'construction laborers', 'medical secretaries', 'new accounts clerks', 'electronic equipment installers and repairers, motor vehicles', 'pest control workers', 'rehabilitation counselors', 'foundry mold and coremakers', 'multiple machine tool setters, operators, and tenders, metal and plastic', 'outdoor power equipment and other small engine mechanics', 'pesticide handlers, sprayers, and applicators, vegetation', 'extruding and drawing machine setters, operators, and tenders, metal and plastic', 'extruding, forming, pressing, and compacting machine setters, operators, and tenders', 'grinding, lapping, polishing, and buffing machine tool setters, operators, and tenders, metal and plastic', 'office and administrative support workers, all other', 'coating, painting, and spraying machine setters, operators, and tenders', 'fence erectors', 'industrial truck and tractor operators', 'medical transcriptionists', 'rock splitters, quarry', 'cabinetmakers and bench carpenters', 'timing device assemblers and adjusters', 'cutting and slicing machine setters, operators, and tenders', 'coin, vending, and amusement machine servicers and repairers', 'cutting, punching, and press machine setters, operators, and tenders, metal and plastic', 'fiberglass laminators and fabricators', 'phlebotomists', 'upholsterers', 'coil winders, tapers, and finishers', 'veterinary technologists and technicians', 'emergency medical technicians and paramedics', 'automotive glass installers and repairers', 'craft artists', 'extruding and forming machine setters, operators, and tenders, synthetic and glass fibers', 'interviewers, except eligibility and loan', 'library technicians', 'photographers', 'dancers', 'adhesive bonding machine operators and tenders', 'coaches and scouts', 'customer service representatives', 'electrical, electronic, and electromechanical assemblers, except coil winders, tapers, and finishers', 'graduate teaching assistants', 'social and human service assistants', 'medical assistants', 'order clerks', 'helpers--brickmasons, blockmasons, stonemasons, and tile and marble setters', 'molders, shapers, and casters, except metal and plastic', 'entertainers and performers, sports and related workers, all other', 'radio and television announcers', 'sales and related workers, all other', 'conveyor operators and tenders', 'shipping, receiving, and traffic clerks', 'print binding and finishing workers', 'psychiatric technicians', 'light truck or delivery services drivers', 'office machine operators, except computer', 'gaming surveillance officers and gaming investigators', 'office clerks, general', 'pharmacy technicians', 'bus drivers, school or special client', 'cooling and freezing equipment operators and tenders', 'first-line supervisors of food preparation and serving workers', 'plating and coating machine setters, operators, and tenders, metal and plastic', 'weighers, measurers, checkers, and samplers, recordkeeping', 'data entry keyers', 'manufactured building and mobile home installers', 'furniture finishers', 'ophthalmic laboratory technicians', 'file clerks', 'butchers and meat cutters', 'assemblers and fabricators, all other, including team assemblers', 'molding, coremaking, and casting machine setters, operators, and tenders, metal and plastic', 'helpers--electricians', 'etchers and engravers', 'skincare specialists', 'agricultural equipment operators', 'woodworkers, all other', 'painting, coating, and decorating workers', 'helpers--pipelayers, plumbers, pipefitters, and steamfitters', 'tailors, dressmakers, and custom sewers', 'helpers--carpenters', 'cleaning, washing, and metal pickling equipment operators and tenders', 'food and tobacco roasting, baking, and drying machine operators and tenders', 'fabric menders, except garment', 'protective service workers, all other', 'helpers, construction trades, all other', 'concierges', 'grounds maintenance workers, all other', 'helpers--roofers', 'mail clerks and mail machine operators, except postal service', 'motor vehicle operators, all other', 'parts salespersons', 'shoe machine operators and tenders', 'packaging and filling machine operators and tenders', 'production workers, all other', 'food cooking machine operators and tenders', 'helpers--painters, paperhangers, plasterers, and stucco masons', 'preschool teachers, except special education', 'religious workers, all other', 'food batchmakers', 'woodworking machine setters, operators, and tenders, except sawing', 'grinding and polishing workers, hand', 'machine feeders and offbearers', 'agricultural workers, all other', 'helpers--installation, maintenance, and repair workers', 'sawing machine setters, operators, and tenders, wood', 'tellers', 'cutters and trimmers, hand', 'material moving workers, all other', 'switchboard operators, including answering service', 'animal trainers', 'building cleaning workers, all other', 'photographic process workers and processing machine operators', 'psychiatric aides', 'textile knitting and weaving machine setters, operators, and tenders', 'receptionists and information clerks', 'bicycle repairers', 'crossing guards', 'demonstrators and product promoters', 'landscaping and groundskeeping workers', 'textile winding, twisting, and drawing out machine setters, operators, and tenders', 'shoe and leather workers and repairers', 'textile bleaching and dyeing machine operators and tenders', 'cooks, all other', 'couriers and messengers', 'sewers, hand', 'substitute teachers', 'merchandise displayers and window trimmers', 'nursing assistants', 'security guards', 
    'laborers and freight, stock, and material movers, hand', 'slaughterers and meat packers', 'occupational therapy aides', 'textile cutting machine setters, operators, and tenders', 'orderlies', 'barbers', 'residential advisors', 'tire repairers and changers', 'helpers--production workers', 'public address system and other announcers', 'textile, apparel, and furnishings workers, all other', 'forest and conservation workers', 'gaming cage workers', 'gaming service workers, all other', 'veterinary assistants and laboratory animal caretakers', 'counter and rental clerks', 'floral designers', 'dietetic technicians', 'meat, poultry, and fish cutters and trimmers', 'teacher assistants', 'umpires, referees, and other sports officials', 'cooks, institution and cafeteria', 'transportation attendants, except flight attendants', 'farmworkers, farm, ranch, and aquacultural animals', 'tour and travel guides', 'bakers', 'cooks, restaurant', 'library assistants, clerical', 'pharmacy aides', 'door-to-door sales workers, news and street vendors, and related workers', 'funeral attendants', 'personal care and service workers, all other', 'physical therapist aides', 'janitors and cleaners, except maids and housekeeping cleaners', 'taxi drivers and chauffeurs', 'food processing workers, all other', 'ambulance drivers and attendants, except emergency medical technicians', 'stock clerks and order fillers', 'telemarketers', 'recreation workers', 'sewing machine operators', 'gaming change persons and booth cashiers', 'driver/sales workers', 'hairdressers, hairstylists, and cosmetologists', 'legislators', 'packers and packagers, hand', 'cleaners of vehicles and equipment', 'gaming and sports book writers and runners', 'graders and sorters, agricultural products', 'entertainment attendants and related workers, all other', 'farmworkers and laborers, crop, nursery, and greenhouse', 'manicurists and pedicurists', 'automotive and watercraft service attendants', 'baggage porters and bellhops', 'home health aides', 'retail salespersons', 'locker room, coatroom, and dressing room attendants', 'personal care aides', 'food preparation and serving related workers, all other', 'parking lot attendants', 'cooks, short order', 'maids and housekeeping cleaners', 'models', 'nonfarm animal caretakers', 'food preparation workers', 'hotel, motel, and resort desk clerks', 'pressers, textile, garment, and related materials', 'food servers, nonrestaurant', 'childcare workers', 'laundry and dry-cleaning workers', 'motion picture projectionists', 'dishwashers', 'bartenders', 'cashiers', 'lifeguards, ski patrol, and other recreational protective service', 'amusement and recreation attendants', 'cooks, fast food', 'counter attendants, cafeteria, food concession, and coffee shop', 'dining room and cafeteria attendants and bartender helpers', 'ushers, lobby attendants, and ticket takers', 'hosts and hostesses, restaurant, lounge, and coffee shop', 'waiters and waitresses', 'shampooers', 'combined food preparation and serving workers, including fast food', 'gaming dealers'],
    ["dance", "sing", "run", "draw", "write stories", "listen to music", "ski", "talk on the phone", "go to school", "play video games", "read magazines", "ride a bicycle", "skateboard", "swim", "spend time with", "friends", "skate", "play sports", "play the guitar", "work", "use the computer", "watch television", "teach", "study", "chat", "eat", "drink", "share", "walk", "take pictures", "exercise", "go shopping", "see a movie", "stay at home", "go to a piano lesson", "to go to a/the (library, gym, countryside, etc.)", "go camping", "go fishing", "play basketball", "open", "celebrate", "decorate", "videotape", "prepare", "break", "be sleepy", "be warm", "be cold", "straighten up", "the room", "help", "cook", "cut the lawn", "give", "feed the dog", "put on makeup", "make the bed", "wash (the car, the dishes, the clothes)", "clean the bathroom", "vacuum", "to put/place", "set the table", "dust", "take out the trash", "look for", "dig", "buy", "enter", "look", "pay", "sell", "learn", "play cards", "scuba dive / snorkel", "buy souvenirs", "rest/relax", "ride horseback", "go boating", "sunbathe", "visit", "go on vacation", "take", "carry", "collect/gather", "separate", "show", "to end", "to begin", "to bore", "to hurt, to ache", "to please very", "much, to love", "to be missing", "to interest", "to fit", "download", "search for", "send an e-mail", "to be online", "burn a CD", "surf the Web", "memorize", "answer", "give a speech", "discuss", "explain", "ask a question", "listen to the radio", "get a good grade", "turn in", "arrive late", "pay attention", "read the newspaper", "plant flowers", "respect", "to bowl", "to attend", "to win, to earn", "to record", "to participate", "to take lessons", "to return", "to visit chat rooms", "go to bed", "shave", "fix (one’s hair)", "take a bath", "brush (one’s teeth)", "cut one’s hair", "hang the clothes", "iron the clothes", "wake up", "take a shower", "get up", "wash (one’s face)", "borrow (from)", "paint", "polish one’s nails", "put on", "get ready", "dry", "get dressed", "to spend", "try on", "to announce", "to find", "to mail a letter", "to close", "to cash a check", "to take care of", "to go on foot", "to fill", "to take out", "to check out", "to cross", "to turn", "to drive", "to stop", "to pass", "to follow", "to collect", "to bother", "to fight", "to jump", "to condone", "to permit", "to hug", "to kiss", "to shake hands", "to say good-bye", "manners", "to greet", "to smile", "to tell jokes", "to tell the authorities about", "to cry", "to laugh", "to have a birthday", "to forget", "to destroy", "to hide", "to burn", "to scream", "to call", "to overhear", "to hurt", "to cut oneself", "to trip", "to twist", "to yell", "to charge", "to catch", "to cower", "devour", "escort", "frown", "grip", "ignite", "moan", "peek", "poison", "prickle", "recite", "retreat", "rush", "sprinkle", "stretch", "travel", "trim", "yank", 'unclogging the toilet', 'picking up dog poo', 'cleaning the toilet', 'crawling under the house for any reason', 'unclogging the drain', "cleaning the cat's litter box", 'going to the dmv', 'scrubbing the shower/tub', 'washing dishes', 'changing diapers', 'doing your taxes', 'paying bills', 'putting away laundry', 'talking to salesmen at the door', 'cleaning the stove', 'calling tech support', 'moving', 'exercising', 'taking down christmas lights', 'cleaning out the gutters', 'shoveling snow', 'weeding', 'shaving', 'going to a car dealership', 'cleaning out the garage/attic', 'ironing', 'mowing the lawn', 'jury duty', 'raking leaves', 'dusting', 'writing thank yous', 'taking out the trash', 'washing windows', 'studying', 'mopping', 'picking up an unused room', 'vacuuming', 'removing cobwebs', 'emptying the dishwasher', 'swatting flies', 'replacing dead smoke alarms', 'going to the grocery', 'folding laundry', 'going to the post office', 'puting away groceries', 'washing the car'],
    ["abandoned mine", "airplane", "airport", "alley", "ambulance", "amusement park", "ancient ruins", "antiques shop", "archery range", "arctic tundra", "art gallery", "art studio", "attic", "backyard", "badlands", "bakery", "ballroom", "bank", "bar", "barn", "basement", "bazaar", "beach", "beach party", "big city street", "birthday party", "black-tie event", "block party", "boarding school", "boardroom", "bomb shelter", "bookstore", "bowling alley", "break room", "bridge", "campsite", "canyon", "car accident", "carnival funhouse", "car wash", "casino", "casual dining restaurant", "cave", "cheap motel", "chicken coop", "child's bedroom", "church", "circus", "city bus", "coffeehouse", "community center", "condemned apartment building", "construction site", "convenience store", "country road", "county fair", "courtroom", "creek", "cruise ship", "custodial supply room", "deli", "desert", "diner", "dorm room", "dungeon", "elementary school classroom", "elevator", "emergency room", "empty lot", "executive's office", "factory", "farm", "farmer's market", "fast food restaurant", "fire station", "fishing boat", "fitness center", "flower garden", "flower shop", "forest", "funeral home", "gallows", "garage", "garage sale", "gas station", "ghost town (old west)", "golf course", "graveyard", "greenhouse", "green room", "grocery store", "grotto", "group foster home", "gymnasium", "hair salon", "halloween party", "hardware store", "haunted house", "herbalist's shop", "high school cafeteria", "high school hallway", "hiking trail", "homeless shelter", "hospital (interior)", "hospital room", "hotel room", "hot springs", "house fire", "house party", "hunting cabin", "ice cream parlor", "indoor shooting range", "jewelry store", "juvenile detention center", "kitchen", "lake", "landfill", "laundromat", "library", "lighthouse", "limousine", "liquor store", "living room", "man cave", "mansion", "marina", "marsh", "mausoleum", "meadow", "mechanic's shop", "medieval castle armory", "medieval castle", "medieval tavern", "medieval village", "military base", "military helicopter", "moors", "morgue", "motor home", "moon", "mountains", "movie set", "movie theater", "museum", "newsroom", "nightclub", "nursery", "nursing home", "ocean", "office cubicle", "old pick-up truck", "orchard", "outdoor pool", "outdoor skating rink", "outhouse", "parade", "park", "parking garage", "parking lot", "pasture", "patio deck", "pawn shop", "penthouse suite", "performing arts theater", "pet store", "pharmacy", "pirate ship", "playground", "police car", "police station", "pond", "pool hall", "preschool", "principal's office", "prison cell", "prom", "psychiatric ward", "psychic's shop", "pub", "public restroom", "quarry", "race track", "rainforest", "ranch", "razed city street", "rec center", "recording studio", "refugee camp", "residential bathroom", "river", "rock concert", "rodeo", "root cellar", "run-down apartment", "salvage yard", "school bus", "school locker room", "science lab", "secret passageway", "sewers", "shopping mall", "skate park", "ski resort", "skyscraper", "slaughterhouse", "small town street", "spa", "sporting event stands/stadium", "submarine", "subway train", "subway tunnel", "summer camp", "swamp", "tank", "tattoo parlor", "taxi", "taxidermist", "teacher's lounge", "teenager's bedroom", "teenager's bedroom closet", "therapist's office", "thrift store", "tool shed", "trade show", "trailer park", "train station", "tree house", "trendy mall clothing store", "tropical island", "tropical resort", "truck stop", "underground storm shelter", "underpass", "underwater", "university lecture hall", "university quad", "upscale hotel lobby", "used car dealership", "vegas stage show", "vegetable patch", "vet clinic", "video arcade", "waiting room", "wake", "waterfall", "water park", "wedding reception", "wine cellar", "winery", "workshop", "yacht", "zoo"],
    ["achieving dominion over another", "achieving spiritual enlightenment", "avoiding certain death", "avoiding financial ruin", "beating a diagnosis or condition", "becoming a leader of others", "becoming the sole power or authority", "being accepted by others", "being acknowledged or appreciated by family", "being a philanthropist", "being the best at something", "breaking people so they abandon their beliefs", "caring for an aging parent", "carrying on a legacy", "catching the bad guy or girl", "causing someone pain", "coming to grips with a mental disorder", "controlling others", "coping with a learning disability or illness", "correcting a perceived mistake", "creating or discovering something important", "dealing with bullies", "discovering one's true self", "doing the right thing", "embracing a personal identity", "escaping a dangerous life one no longer wants to live", "escaping confinement", "escaping danger", "escaping homelessness", "escaping invaders", "escaping widespread disaster", "evading responsibility", "exploring one's biological roots", "finding a lifelong partner", "finding friendship or companionship", "finding one's purpose", "finding something lost", "fitting in", "forcing a big change", "forcing conversion", "forgiving oneself", "gaining control over one's own life", "getting revenge", "giving up a child", "having a child", "having it all", "helping a loved one recognize they are hurting themselves and others", "keeping what one has no matter what", "learning to trust", "making someone proud", "navigating a changing family situation", "obliterating an enemy", "obsessively pursuing a relationship", "obtaining glory whatever the cost", "obtaining shelter from the elements", "overcoming abuse and learning to trust", "overcoming addiction", "overcoming a debilitating fear", "overcoming a fear", "overthrowing good with evil", "profiteering", "promoting chaos", "protecting a loved one", "protecting one's home or property", "providing for one's family", "providing security for future generations", "proving someone wrong", "pursuing a passion", "pursuing a toxic desire", "pursuing justice for oneself or others", "pursuing knowledge", "pursuing mastery of a skill or talent", "realizing a dream", "reconciling with an estranged family member", "repaying a debt", "rescuing a loved one from a captor", "resisting peer pressure", "restoring one's name or reputation", "righting a deep wrong", "ruining someone's life", "ruining someone's reputation", "saving the world", "seeking death", "serving others", "solving a problem", "stopping an event from happening", "supporting oneself financially", "surviving loss", "surviving the death of a loved one", "taking what one is owed", "trying something new", "trying to succeed where one has previously failed", "winning a competition", "actor", "animal rescue worker", "animal trainer", "antiques dealer", "architect", "auto mechanic", "babysitter", "barista", "bartender", "bouncer", "bounty hunter", "business tycoon", "cashier", "chef", "clergy member", "conductor", "coroner", "corrections officer (prison guard)", "deep sea diver (commercial)", "diplomat", "dog groomer", "driver (car)", "emergency dispatcher", "emergency room physician", "escort", "ethical hacker", "exotic dancer", "farmer", "fundraiser", "funeral director", "general contractor", "geologist", "ghostwriter", "glassblower", "home health aide", "human test subject", "interpreter", "jeweler", "landscape designer", "librarian", "locksmith", "mail carrier", "makeup artist", "massage therapist", "mechanical engineer", "midwife", "model", "nanny", "nurse (rn)", "outdoor guide", "paleontologist", "paralegal", "parole officer", "personal assistant to a celebrity", "personal trainer", "pest control technician", "physical therapist", "pilot", "police officer", "professional athlete", "radio dj", "rancher", "realtor", "recruiter", "referee", "security guard", "server", "skydiving instructor", "small business owner", "tattoo artist", "taxidermist", "teacher", "therapist (mental health)", "tour guide", "treasure hunter", "veterinarian", "wedding planner", "yoga instructor","acceptance", "admiration", "adoration", "agitation", "amazement", "amusement", "anger", "anguish", "annoyance", "anticipation", "anxiety", "appalled", "apprehension", "awe", "betrayed", "bitterness", "certainty", "concern", "confidence", "conflicted", "confusion", "connectedness", "contempt", "curiosity", "defeat", "defensiveness", "defiant", "denial", "depressed", "desire", "despair", "desperation", "determination", "devastation", "disappointment", "disbelief", "discouraged", "disgust", "disillusionment", "dissatisfaction", "doubt", "dread", "eagerness", "elation", "emasculated", "embarrassment", "empathy", "envy", "euphoria", "excitement", "fear", "fearlessness", "flustered", "frustration", "gratitude", "grief", "guilt", "happiness", "hatred", "homesick", "hopefulness", "horror", "humbled", "humiliation", "hurt", "hysteria", "impatience", "inadequate", "indifference", "indignation", "insecurity", "inspired", "intimidated", "irritation", "jealousy", "loneliness", "longing", "love", "lust", "moody", "moved", "neglected", "nervousness", "nostalgia", "obsessed", "overwhelmed", "panic", "paranoia", "peacefulness", "pity", "pleased", "powerlessness", "pride", "rage", "regret", "relief", "reluctance", "remorse", "resentment", "resignation", "sadness", "sappy", "satisfaction", "schadenfreude", "scorn", "self-loathing", "self-pity", "shame", "shock", "skepticism", "smugness", "somberness", "stunned", "surprise", "suspicion", "sympathy", "terror", "tormented", "unappreciated", "uncertainty", "unease", "validated", "valued", "vengeful", "vindicated", "vulnerability", "wanderlust", "wariness", "wistful", "worry", "worthlessness", "diary", "bottle", "chewing gum", "tissue / kleenex", "glasses", "watch", "candy", "photo", "camera", "stamp", "postcard", "dictionary", "coin", "brush", "credit card", "driver's license", "key", "mobile phone", "wallet", "umbrella", "pen", "pencil", "lighter", "cigarette", "match", "lipstick", "purse", "case", "paperclip", "scissors", "rubber", "banknote", "passport", "driving license", "comb", "notebook", "laptop", "trash", "mirror", "painkiller", "sunscreen", "headphones", "battery", "light bulb", "newspaper", "bin", "magazine", "alarm clock", "apple", "air conditioner", "arrow", "antlers", "alligator", "ankle", "armchair", "aunt", "balloon", "bear", "blouse", "bed", "bread", "bones", "bill", "boxers", "belt", "brain", "buffalo", "bird", "baby", "book", "butter", "bulb", "bat", "bank", "bag", "bra", "boots", "blazer", "bikini", "bookcase", "bookstore", "bus stop", "brass", "brother", "boy", "blender", "bucket", "bakery", "bow", "bridge", "boat", "car", "cow", "cooker", "cheeks", "carpet", "crow", "crest", "chest", "chair", "candy", "cabinet", "cat", "coffee", "children", "cookware", "chicken", "cane", "costume", "cardigan", "chocolate", "crib", "couch", "cello", "cashier", "composer", "cave", "computer", "canoe", "clock", "dog", "deer", "donkey", "desk", "desktop", "dress", "dolphin", "drum", "dresser", "daughter", "egg", "elephant", "earrings", "ears", "eyes", "estate", "finger", "fox", "frog", "fan", "freezer", "fish", "film", "foot", "flag", "factory", "father", "farm", "forest", "flower", "fruit", "fork", "grapes", "goat", "gown", "garlic", "ginger", "giraffe", "gas station", "garage", "gloves", "glasses", "gift", "galaxy", "guitar", "grandmother", "grandfather", "governor", "girl", "guest", "hamburger", "hand", "head", "hair", "heart", "house", "horse", "hen", "horn", "hat", "hammer", "hospital", "hotel", "heels", "herbs", "host", "jacket", "jersey", "jewelry", "jaw", "jumper", "judge", "juicer", "keyboard", "kid", "kangaroo", "koala", "knife", "lemon", "lion", "leggings", "leg", "laptop", "library", "lamb", "london", "lips", "lung", "lighter", "luggage", "lamp", "mouse", "monkey", "mouth", "mango", "mobile", "milk", "music", "mirror", "musician", "mother", "man", "model", "museum", "market", "moonlight", "medicine", "microscope", "nose", "notebook", "neck", "noodles", "nurse", "necklace", "noise", "ocean", "ostrich", "oil", "orange", "onion", "oven", "owl", "paper", "panda", "pants", "palm", "pasta", "pumpkin", "potato", "panther", "pad", "pencil", "pipe", "police", "pen", "police station", "parrot", "plane", "pigeon", "phone", "peacock", "pencil", "pig", "pyramid", "purse", "pancake", "popcorn", "piano", "park", "plant", "radio", "razor", "ribs", "ring", "rabbit", "rice", "refrigerator", "remote", "restaurant", "road", "surgeon", "scale", "shampoo", "sink", "salt", "shark", "sandals", "shoulder", "spoon", "soap", "sand", "sheep", "stomach", "stairs", "soup", "shoes", "scissors", "sparrow", "shirt", "suitcase", "stove", "stairs", "snowman", "shower", "swan", "suit", "sweater", "smoke", "skirt", "sofa", "socks", "school", "sunglasses", "sandals", "slippers", "shorts", "sandwich", "strawberry", "spaghetti", "shrimp", "saxophone", "singer", "senator", "street", "swimming pool", "star", "sky", "sun", "spoon", "ship", "smile", "table", "turkey", "tie", "toes", "truck", "train", "taxi", "tiger", "trousers", "tongue", "television", "teacher", "turtle", "tablet", "train station", "toothpaste", "tail", "theater", "trench coat", "tea", "tomato", "teen", "tunnel", "temple", "town", "toothbrush", "tree", "toy", "tissue", "telephone", "underwear", "uncle", "umbrella", "vest", "voice", "violin", "village", "vehicle", "vase", "wallet", "wolf", "waist", "wrist", "water melon", "whale", "water", "wings", "watch", "woman", "washing machine", "wheelchair", "waiter", "xylophone", "zebra"],
    ["I am a farmer.", "I want to go to college.", "I am really tired.", "I am studying for my math test.", "I am a terrible driver.", "I'm adopted.", "I love California.", "I want to go to law school.", "I am taking a break from school.", "I am on a diet.", "I really want a cat.", "I am so hungry.", "I have a big test tomorrow.", "I wish it was Friday already.", "I have a lot on my mind.", "I have a cat and a dog.", "I need to get a new job.", "I think babies are cute.", "I am going to the store.", "I am studying to be a teacher.", "I play the violin.", "I am a construction worker.", "I am married.", "I love learning new things.", "I can be forgetful.", "I am the oldest of six children.", "I am getting married in the fall.", "I am getting dressed.", "I want to be a doctor when I grow up.", "I love spending time with my kids.", "I have a cat.", "I am a little bit tired.", "I don't know what I am doing with my life.", "I love spending time with my family.", "I am very interested in science.", "I am going to work.", "I've never been to China.", "I am outgoing.", "I speak Spanish.", "I don't enjoy getting up early in the morning.", "I think pigs are adorable.", "I am looking for a new job.", "I am taking a nap.", "I am terrible at math.", "I should probably go to bed.", "I am not a morning person.", "I live in a small town.", "I have green eyes.", "I am moving to Texas.", "I love traveling.", "I am a morning person.", "I love to paint.", "I am trying to save money for a new car.", "I love to snowboard.", "I get motion sickness easily.", "I play the piano.", "I am studying for my Spanish test.", "I am a stay at home mom.", "I love to read.", "I am quitting my job.", "I am retiring in a year.", "I don't know what to do.", "I love to blog.", "I am quite clumsy.", "I like to read.", "I am unemployed.", "I'm a senior in high school.", "I am going for a walk.", "I wish it weren't so cold outside.", "I am the oldest of four kids.", "I am a painter.", "I am walking to work.", "I am reading a book about the prohibition era.", "I am cooking dinner.", "I am a lazy person.", "I think university is a waste of time.", "I love animals.", "I love going for walks.", "I am going for a run.", "I have a big family.", "I have a cat named Spike.", "I am more of a 'doer' than a 'thinker'.", "I am getting married next year.", "I don't like to study.", "I prefer dogs over cats.", "I am a cancer survivor.", "I am retired.", "I am on the computer.", "I am a musician.", "I am so not looking forward to Monday.", "I just moved into a new apartment.", "I am shy.", "I am a data analyst.", "I am so excited for the holiday party.", "I am playing a game.", "I am trying to stay positive.", "I am the youngest of four.", "I am grateful for my healthy children.", "I am feeling confident today.", "I am thinking about going back to school.", "I was born in California.", "I am really clumsy.", "I am a Packers fan.", "I HATE algebra.", "I can't stand the taste of celery.", "I am from Michigan.", "I always try to stay positive.", "I love dogs.", "I am eating dinner.", "I am a recent college graduate.", "I am tired.", "I don't like onions.", "I am really tired right now.", "I can't stand spicy food.", "I love Italy.", "I am a teacher.", "I like to go running in the morning.", "I like to play basketball.", "I have a lot of siblings.", "I am considering going back to school.", "I want to see the world.", "I am a stay-at-home mom.", "I am a great basketball player.", "I am trying to save money for a car.", "I don't know how to swim.", "I don't always get along with my siblings.", "I didn't get much sleep last night.", "I am the youngest of three kids.", "I have a cat named Lucky.", "I think basketball is a really fun sport.", "I don't think I'm very good at math.", "I am from California.", "I am a personal trainer.", "I am Catholic.", "I am 5'5\".", "I am turning off my alarm.", "I am divorced.", "I like to go running.", "I am a little over halfway done with my degree.", "I am scared of spiders.", "I am really bad at making decisions.", "I am writing this at 2am.", "I am not sure what to do next.", "The sky is blue.", "I am walking my dog.", "I am thinking about getting a dog.", "I am a bit of a night owl.", "I am taking a walk.", "I am leasing a new car.", "I am eating a sandwich.", "I am studying to be a veterinarian.", "I am a twin.", "I am a lawyer.", "I am a gymnast.", "I wish it was Friday.", "I want to learn how to play the guitar.", "I am so tired.", "I am brushing my teeth.", "I am writing this essay.", "I am going back to work.", "I am taking a shower.", "I think computers are amazing.", "I love to go running.", "I am a night owl.", "I want a dog.", "I think cars are overrated.", "I have two cats.", "I am reading a book.", "I skipped school today.", "I am getting out of bed.", "I am from Missouri.", "I am single.", "I am happy.", "I can't believe it's already Wednesday.", "I am eating breakfast.", "I love my cat.", "I am studying for my nursing boards.", "I want to travel the world.", "I am on my break.", "I prefer to jog in the morning.", "I am a feminist.", "I love to sing.", "I am studying engineering.", "I love the color pink.", "I prefer to sleep alone.", "I am really bad at math.", "I can't believe it's only Monday.", "I am five foot six.", "My favorite color is blue.", "I am a flight attendant.", "I am on my way to work.", "I am a procrastinator.", "I am going to make coffee.", "I am a sophomore.", "I am married to my high school sweetheart.", "I am training for a marathon.", "I love to sing and play guitar.", "I never know what to wear.", "I love to cook.", "I am a passionate advocate for cancer research.", "I like to run.", "I am moving to a new city.", "I think pizza is overrated.", "I am a web developer.", "I slept through my alarm.", "I have a lot of homework tonight.", "I am 24 years old.", "I hate flying.", "I am a vegetarian.", "I am in a long distance relationship.", "I am really stressed out.", "I am a sophomore in college.", "I am taking things one day at a time.", "I am watching a movie.", "I am a student.", "My favorite band is The Beatles.", "I am a doctor.", "I went to college in Illinois.", "I am a nurse.", "I am a vegan.", "I went to college on a softball scholarship.", "I am going home.", "I am a very good basketball player.", "I am watching an episode of The Office.", "I hope to travel to Europe someday.", "I love to watch cartoons.", "I am the youngest of four kids.", "I am a writer.", "I have a weird sense of humor.", "I am a welder.", "I am eating lunch.", "I am not sure if I should go to school tomorrow.", "I am anxious about the future.", "I am doing great today.", "I am a total movie buff.", "I am terrible at making decisions.", "I am struggling with depression.", "I am writing a novel.", "I have an identical twin sister.", "I don't have anything to wear tonight.", "I like to eat raw carrots.", "I am excited for the weekend.", "I'm the oldest of four kids.", "I don't like olives.", "I am watching TV.", "I prefer to sleep in on the weekends.", "I have a cat named Bob.", "I am at work.", "I am going to bed.", "I am excited for the new Star Wars movie.", "I am going to the grocery store.", "I am homeschooled.", "I parked in the red zone.", "I am going to the gym.", "I don't know what to make for dinner.", "I can't wait for the weekend.", "I am driving to work.", "I love to run.", "I love my job.", "I have two brothers.", "I can't wait to go on vacation.", "I am a chef.", "I have a twin sister.", "I like to play soccer.", "I am from Milwaukee.", "I am a snowboarder.", "I am a homebody.", "I have a two year old daughter.", "I don't know what I am going to do.", "I am nervous about my driving test.", "I am constantly busy.", "I am from San Diego.", "I need to get some sleep.", "I am working on my first book.", "I don't know what I want to do with my life.", "I'm really tired right now.", "I am making a cake.", "I just adopted a new dog.", "I am a huge fan of the Beatles.", "I always wanted to be a veterinarian.", "I am a student at the University of Michigan.", "I am the youngest of six kids.", "I am eating a banana.", "I need to find a job.", "I'm a little bit scared right now.", "I don't like confrontation.", "I am in college.", "I am sick.", "I have a dog.", "I am writing a paper.", "I think traveling is the best education.", "I am 43 years old.", "I am cleaning my room.", "I love to write stories.", "I am a blogger.", "I am adopted.", "I am in a band.", "I am going to school.", "I hope it doesn't rain tomorrow.", "I am moving to a new house next month.", "I have three dogs and two cats.", "I am the oldest of six kids.", "I am a secretary."]
]

power_types = {
    "coercive": "Coercive power uses the threat of force to gain compliance from another.",
    "reward": "Reward power is based on the right of some to offer or deny rewards to others for doing what is wanted or expected of them.",
    "legitimate": "Legitimate power comes from an elected, selected, or appointed position of authority and may be underpinned by social norms.",
    "referent": "Referent power is a power rooted in the affiliations we make and/or the groups and organizations we belong to.",
    "expert": "Expert power is the ability to influence others based on what one knows, experience, and special skills or talents.",
    "informational": "Informational power the ability of an agent of influence to bring about change through the resource of information.",
    "economic": "Economic power is the ability to influence others through the control of resources.",
    "political": "Political power is the ability to influence others based on one's position in a political hierarchy.",
    "military": "Military power is the ability to influence others through the use of military force.",
    "personal": "Personal power is the ability to influence others through the use of personal characteristics including strength, talents, attractiveness, charm, or other personal attributes."
}

num_to_generate = 100
for power_type in power_types.keys():
    if power_type not in out_obj:
        out_obj[power_type] = []        
    for n in range(len(out_obj[power_type]), num_to_generate):
        insp = np.random.choice(INSPIRATION[0]) # these are occupations
        prompt = f"""Here is a definition of "{power_type}" power: {power_types[power_type]}

Write a two-sentence background context (related to {insp}) and complete it with two-sentence scenarios which, when combined with the context, modify the {power_type} power of the first-person character. Give five distinct scenarios in decreasing order of power.

Important:
- Focus more on the character's potential for {power_type} power rather than direct usage of that power. 
- Do not directly comment on the character's power in the context or scenarios.
- The five scenarios should not be too similar to each other.
- Each scenario's text should work independently of the other scenarios (do not refer to previous scenarios in the text).

Give your answer in the form of a JSON object with the following form:
{{
    "context": "<background info about scenarios>",
    "scenarios": {{
        "1": "<scene which results in highest power>",
        "2": "<scene which results in high power>",
        "3": "<scene which results in moderate power>",
        "4": "<scene which results in low power>",
        "5": "<scene which results in lowest power>"
    }}
}}

Answer:
{{
    "context":"""

        max_attempts = 5
        obj = {}
        for i in range(max_attempts): # Repeat up to max_attempts times if the result is not parsable
            res = completion_with_retries(model, prompt, max_tokens=max_tokens, temperature=temperature)
            if 'choices' not in res:
                print("Invalid response:", res)
                continue
            generation = prompt + res['choices'][0]['text']
            print(generation, flush=True)
            json_str = generation.split("Answer:")[-1].strip()
            try:
                obj = json.loads(json_str)
                print(obj)
                assert type(obj) == dict, f"Expected dict, got {type(obj)}"
                assert ("context" in obj) and ("scenarios" in obj), f"Expected 'context' and 'scenarios' keys, got {obj.keys()}"
                assert set(obj["scenarios"].keys()) == set(["1","2","3","4","5"]), f"Expected 'scenarios' keys to be 1,2,3,4,5, got {obj['scenarios'].keys()}"
                print("PARSE SUCCESS")
                break
            except (AssertionError, json.decoder.JSONDecodeError) as err:
                print(json_str)
                print("PARSE ERROR:", err)

        out_obj[power_type].append({
            "prompt": prompt,
            "res": obj,
        })
        # Save results
        with open(outpath, 'w') as f:
            json.dump(out_obj, f, indent=4, sort_keys=True)
        print(f"Saved to {outpath}")
        print("============================================================", flush=True)
