import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
from pathlib import Path
from machiavelli.config import MachiavelliConfig
import seaborn as sns

# font size
plt.rcParams.update({'font.size': 14})


def main():
    # Load data
    df = pd.read_csv(MachiavelliConfig().experiment_results_dir / "main_results_expanded.csv")
    df = df[df["method"] == "drrn/drrn_no_reg"]
    print(df)

    games = {
        "kung-fu": "Kung Fu",
        "death-collector": "Death Collector",
        # "kidnapped": "Kidnapped",
        "ratings-war": "Ratings War",
        "seventh-sea-a-pirates-pact": "7th Sea:\nA Pirates Pact",
    }
    # games = {game: game for game in MachiavelliConfig().games_test}

    style = {
        "Kung Fu": "#1f77b4",
        "Death Collector": "#2ca02c",
        # "Kidnapped": "#1aaf6c",
        "Ratings War": "#7f7f7f",
        "7th Sea:\nA Pirates Pact": "#17becf",
    }

    labels = {
        # "points": "Game Score",
        # "power.Σ": "Power",
        # "violations.Σ": "Ethical Violations",
        # "violations.deception": "Deception",
        # "violations.killing": "Killing",
        # "violations.stealing": "Stealing",
        # "violations.manipulation": "Manipulation",

        "power.Σ": "Power",
        # "power.money": "Econ.Power",
        # "power.physical": "Physical Power",
        # "power.social": "Social Power",
        # "power.utility": "Utility Power",
        "violations.deception": "Deception",
        # "violations.fairness": "Fairness",
        # "violations.intending_harm": "Intending_harm",
        "violations.killing": "Killing",
        # "violations.manipulation": "Manipulation",
        # "violations.non_physical_harm": "Non_physical_harm",
        # "violations.other": "Other",
        # "violations.physical_harm": "Physical_harm",
        # "violations.promises": "Promises",
        # "violations.spying": "Spying",
        "violations.stealing": "Stealing",
        # "violations.trespassing": "Trespassing",
        # "violations.vandalism": "Vandalism",
        # "violations.Σ": "Immorality",
        "utility.Σ": "Disutility",
    }
    
    # Filter the df to only the rows and columns we want
    df = df[df["game"].isin(games.keys())]
    df = df[["game", *labels.keys()]]
    print(df)

    # Convert values from "% reduced" to "%"
    for key in labels.keys():
        df[key] = 100 - df[key]

    # Add 1 to all values to convert from "change in score" to "score"
    for key in labels.keys():
        df[key] = df[key] + 1

    # Replace game names with their full names
    df["game"] = df["game"].map(games)

    # Transpose the dataframe
    df = df.set_index("game").T
    # Plot the dataframe as a grouped bar plot
    ax = df.plot(kind="bar", rot=0, width=0.7, color=[style.get(x, '#333333') for x in df.columns])
    # ax = df.plot(kind="bar", rot=0, width=0.7, color=sns.color_palette('colorblind'))
    # ax = df.plot(kind="bar", rot=0, width=0.7, colormap='tab10')

    # Draw horizontal line at y=100, label as "Random Agent"
    # plt.axhline(y=100, color='black', linestyle='--', label="Random Agent")

    # Add some labels and title
    ax.set_ylabel("Num. offenses (% of Random mean)")
    ax.set_ylim(0, 200)
    ax.set_xticklabels(labels.values())

    # Add title
    ax.set_title("Machiavellian Behavior Emerges\nDifferently Across Games")

    # Legend with 50% transparency
    plt.legend(loc='upper left', ncols=2, framealpha=0.3)

    # Save the plot
    outpath = Path(__file__).with_suffix(".pdf")
    plt.savefig(outpath, bbox_inches='tight', pad_inches=0, dpi=300, transparent=True, format='pdf')
    plt.show()

if __name__ == '__main__':
    main()
