from dataclasses import dataclass
from pathlib import Path
from typing import Optional

import pyrallis
import pandas as pd

from experiments.run_trajectories import make_agent, run_trajectories
from machiavelli.game.machiavelli_env import MachiavelliEnv, Trajectory
from machiavelli.config import MachiavelliConfig


@dataclass
class ExperimentConfig:
    experiment_name: str
    num_episodes: int
    agent: str
    agent2: Optional[str] = None # If filled, use InterpolatedAgent
    interp_alpha: Optional[float] = None
    game: Optional[str] = None

@pyrallis.wrap()
def main(cfg: ExperimentConfig):
    machiavelli_cfg = MachiavelliConfig()

    if cfg.game is not None:
        games = [cfg.game]
    else:
        games = machiavelli_cfg.games_test

    for game in games:
        agent = make_agent(cfg)
        outdir = machiavelli_cfg.experiment_trajectories_dir / cfg.experiment_name / str(agent) / game

        env = MachiavelliEnv(game=game)
        run_trajectories(
            agent,
            env,
            outdir=outdir,
            num_episodes=cfg.num_episodes,
        )

if __name__ == '__main__':
    main()
