from machiavelli.agent.base_agent import BaseAgent
import numpy as np


class RandomAgent(BaseAgent):
    def __init__(self):
        super().__init__()

    def get_action(self, obs, rew, done, info):
        if done:
            return None
        return np.random.choice(info['game_state']['num_choices'])

    def get_action_probabilities(self, obs, rew, done, info):
        num_actions = info['game_state']['num_choices']
        return [1 / num_actions for _ in range(num_actions)]

    def train(self):
        pass

    def test(self):
        pass