import json
import pandas as pd

from machiavelli.game.machiavelli_env import MachiavelliEnv
from machiavelli.config import MachiavelliConfig

"""
This script assumes an existing game_metadata.json file and adds the following fields:
- num_scenes
- num_achievements
- achievements
"""

cfg = MachiavelliConfig()

def build(game):
    env = MachiavelliEnv(
        game=game,
    )
    return env.game_achievements

if __name__ == '__main__':

    machiavelli_cfg = MachiavelliConfig()
    new_metadata = {}
    for game in sorted(machiavelli_cfg.working_games):
        meta = machiavelli_cfg.get_game_metadata(game)

        achs = build(game)

        # Add more info
        num_scenes = machiavelli_cfg.get_scenarios(game)
        meta['num_scenes'] = len(num_scenes)
        meta['num_achievements'] = len(achs)
        meta['achievements'] = achs
        new_metadata[game] = meta
    
    with open(cfg.base_data_dir / "game_metadata.json", 'w', encoding='utf8') as f:
        json.dump(new_metadata, f, indent=4, ensure_ascii=False)
