import pandas as pd
import streamlit as st
st.set_page_config(layout="wide")

from machiavelli.config import MachiavelliConfig


def main():
    cfg = MachiavelliConfig()

    input_file = st.selectbox("Select report file", cfg.trajectories_dir.glob("*.csv"))
    df = df = pd.read_csv(input_file)

    st.title(input_file.stem)

    step_idx = st.slider("Step", 0, len(df))
    st.text(df['observations'][step_idx])

    df_num = df.select_dtypes(['number'])
    # Remove all columns with fewer than 2 unique values
    df_num = df_num.loc[:, [len(df_num[col].unique()) > 2 for col in df_num.columns]]

    cols = st.columns(6)

    unique_prefixes = sorted(list(set([col_name[:4] for col_name in df_num.columns])))
    for i, prefix in enumerate(unique_prefixes):
        with cols[i % len(cols)]:
            st.line_chart(df_num[[col_name for col_name in df_num.columns if col_name.startswith(prefix)]])
    
if __name__ == '__main__':
    main()
