function convert_to_images(model, version, BSD_dir, split, transform, subset)

if ~exist('version', 'var') || isempty(version)
    version = 0;
end
if ~exist('BSD_dir', 'var') || isempty(BSD_dir)
    BSD_dir = '~/predseg/BSDS500/';
end
if ~exist('split', 'var') || isempty(split)
    split = 'train';
end
if ~exist('transform', 'var') || isempty(transform)
    transform = 'quant';
end
if ~exist('subset', 'var') || isempty(subset)
    subset = '';
end

inDir = fullfile(BSD_dir, 'model_output', model, ...
    sprintf('version%d', version), sprintf(['%s_%s', subset], split, transform));



iids = dir(fullfile(inDir,'*.mat'));
for i = 1:numel(iids)
    im = load(fullfile(inDir,iids(i).name));
    imwrite(im.ucm, fullfile(inDir,[iids(i).name(1:end-4), '.png']))
    fprintf('%d\n', i)
end