function bench_bsds500(model, version, BSD_dir, split, transform)
addpath benchmarks

if ~exist('version', 'var') || isempty(version)
    version = 0;
end
if ~exist('BSD_dir', 'var') || isempty(BSD_dir)
    BSD_dir = '~/predseg/BSDS500/';
end
if ~exist('split', 'var') || isempty(split)
    split = 'train';
end
if ~exist('transform', 'var') || isempty(transform)
    transform = 'quant';
end

close all;clc;

imgDir = fullfile(BSD_dir, 'data', 'images', split);
gtDir = fullfile(BSD_dir, 'data', 'groundTruth', split);

inDir = fullfile(BSD_dir, 'model_output', model, ...
    sprintf('version%d', version), sprintf('%s_%s', split, transform));
outDir = fullfile(BSD_dir, 'model_output', model, ...
    sprintf('version%d', version), sprintf('%s_%s_eval', split, transform));

mkdir(outDir);

% running all the benchmarks can take several hours.
if isfolder(fullfile(inDir, '0'))
    tic;
    boundaryBench(imgDir, gtDir, fullfile(inDir, '0'), fullfile(outDir, '0'), 99, 0.0075, false)
    boundaryBench(imgDir, gtDir, fullfile(inDir, '1'), fullfile(outDir, '1'), 99, 0.0075, false)
    boundaryBench(imgDir, gtDir, fullfile(inDir, '2'), fullfile(outDir, '2'), 99, 0.0075, false)
    boundaryBench(imgDir, gtDir, fullfile(inDir, '3'), fullfile(outDir, '3'), 99, 0.0075, false)
    toc;
else
    tic;
    boundaryBench(imgDir, gtDir, inDir, outDir, 99, 0.0075, false)
    toc;
end