function plot_evals(evalDirs, cols, names)
% plot evaluation results.
% Pablo Arbelaez <arbelaez@eecs.berkeley.edu>
% adapted by us to implement the
% following changes:
% - plotting for multiple folders
addpath benchmarks

if nargin<2 || isempty(cols)
    cols = string([]);
    for i = 1:numel(evalDirs)
        cols(i) = 'r';
    end
end

if nargin<3 || isempty(names)
    names = string([]);
    for i = 1:numel(evalDirs)
        names(i) = 'M1';
    end
end

open('isoF.fig');
hold on

for i = 1:numel(evalDirs)
    evalDir = evalDirs(i);
    fwrite(2,sprintf('\n%s\n',evalDir));

    if exist(fullfile(evalDir,'eval_bdry_thr.txt'),'file'),
        prvals = dlmread(fullfile(evalDir,'eval_bdry_thr.txt')); % thresh,r,p,f
        f = prvals(:,2)>=0.01;
        prvals = prvals(f,:);


        evalRes = dlmread(fullfile(evalDir,'eval_bdry.txt'));
        if size(prvals,1)>1
            if ndims(cols) > 1
                plot(prvals(1:end,2),prvals(1:end,3),'color', cols(i,:),'LineWidth',3);
            else
                plot(prvals(1:end,2),prvals(1:end,3),cols(i),'LineWidth',3);
            end
        else
            if ndims(cols) > 1
                plot(evalRes(2),evalRes(3),'o','MarkerFaceColor',cols(i,:),'MarkerEdgeColor',cols(i),'MarkerSize',8);
            else
                plot(evalRes(2),evalRes(3),'o','MarkerFaceColor',cols(i),'MarkerEdgeColor',cols(i),'MarkerSize',8);
            end
        end

        fprintf('Boundary\n');
        fprintf('ODS: F( %1.2f, %1.2f ) = %1.2f   [th = %1.2f]\n',evalRes(2:4),evalRes(1));
        fprintf('OIS: F( %1.2f, %1.2f ) = %1.2f\n',evalRes(5:7));
        fprintf('Area_PR = %1.2f\n\n', evalRes(8));
    end

    if exist(fullfile(evalDir,'eval_cover.txt'),'file'),
        evalRes = dlmread(fullfile(evalDir,'eval_cover.txt'));
        fprintf('Region\n');
        fprintf('GT covering: ODS = %1.2f [th = %1.2f]. OIS = %1.2f. Best = %1.2f\n',evalRes(2),evalRes(1),evalRes(3:4));
        evalRes = dlmread(fullfile(evalDir,'eval_RI_VOI.txt'));
        fprintf('Rand Index: ODS = %1.2f [th = %1.2f]. OIS = %1.2f.\n',evalRes(2),evalRes(1),evalRes(3));
        fprintf('Var. Info.: ODS = %1.2f [th = %1.2f]. OIS = %1.2f.\n',evalRes(5),evalRes(4),evalRes(6));

    end
end

set(gca, 'FontSize', 14)
xticks([0,0.2,0.4,0.6,0.8,1])
yticks([0,0.2,0.4,0.6,0.8,1])
