# 🚀 Usage

## DiT-FeMo

### 1. Set Up Conda Environment

Follow the official documentation instructions to create the Conda environment:

```bash
conda env create -f environment.yml
conda activate DiT
pip install flash-attention
```

#### Single GPU
```bash
python sample.py \
  --ddim-sample \
  --interval 1 \
  --max-order 0 \
  --num-sampling-steps 50 \
  --test-FLOPs \
  --a -0.02 --b 0 --gamma 0.001
```
#### Distributed (DDP)
```bash
torchrun --nnodes=1 --nproc_per_node=1 sample_ddp.py \
  --model DiT-XL/2 \
  --per-proc-batch-size 50 \
  --image-size 256 \
  --cfg-scale 1.5 \
  --ddim-sample \
  --num-sampling-steps 50 \
  --sample-dir " " \
  --interval 5 \
  --max-order 1 \
  --num-fid-samples 50000 \
  --a -0.3 --b -0.1 --gamma 0.01
```