## 🚀 Usage

# FLUX-FeMo

## 1. Set Up Conda Environment

Follow the official documentation instructions to create the Conda environment:

```bash
conda create -n flux python=3.10
conda activate flux
pip install -e ".[all]"
```

## 2.Download Checkpoints with Your Hugging Face Token
If you experience connection issues with Hugging Face, you can use the Hugging Face mirror:
```bash
export HF_ENDPOINT=https://hf-mirror.com
```
Make sure you have obtained the necessary permissions and exported your token:
```bash
huggingface-cli download --token YOUR_HF_TOKEN --resume-download black-forest-labs/FLUX.1-dev --local-dir /path/to/save/pretrained_models
huggingface-cli download --token YOUR_HF_TOKEN --resume-download black-forest-labs/FLUX.1-schnell --local-dir /path/to/save/pretrained_models
huggingface-cli download --token YOUR_HF_TOKEN --resume-download google/t5-v1_1-xxl --local-dir /path/to/save/pretrained_models
huggingface-cli download --token YOUR_HF_TOKEN --resume-download openai/clip-vit-large-patch14 --local-dir /path/to/sav
```

### 3.Inference

```bash
python src/sample.py \
  --prompt_file " " \
  --width 1024 --height 1024 \
  --model_name flux-dev \
  --N 7 \
  --add_sampling_metadata \
  --output_dir " " \
  --num_steps 50 \
  --a 0.3 --b 0.35 --gamma 0.01
```