import re

def extract_question(text):
    """
    Extract a question between 'Question:' and 'Think step-by-step.' from text.
    
    Args:
        text (str): The input text containing the question
        
    Returns:
        str: The extracted question or None if not found
    """
    # Pattern to match "Question: [question] Think step-by-step."
    pattern = r'Question:\s*(.*?)\s*Think step-by-step\.'
    
    # Search for the pattern in the text
    match = re.search(pattern, text)
    
    # Return the extracted question if found
    if match:
        return match.group(1).strip()
    else:
        return None

def extract_ans_from_response(raw_response, split_seg_list = ["The answer is: ", "The answer is",  "the answer is:", "the answer is", "答案是：", "答案是"]):
    # for Thinking model
    if "<Output>\n" in raw_response:
        raw_response = raw_response.split("<Output>\n")[-1].replace("</Output>", "").strip("\n")
    if "<Answer>\n" in raw_response:
        raw_response = raw_response.split("<Answer>\n")[-1].replace("</Answer>", "").strip("\n")
    # else
    potentinal_ans = raw_response
    for split_seg in split_seg_list:
        if split_seg in potentinal_ans:
            potentinal_ans = potentinal_ans.split(split_seg)[-1].split("\n\n")[0]
            return potentinal_ans
    return " "

if __name__ == "__main__":
    # Example usage
    sample_text = """Question: In what country is Normandy located? Think step-by-step."""
    extracted_question = extract_question(sample_text)
    print(f"Extracted question: {extracted_question}")