#!/bin/bash
BASE_PATH="[PATH_to_THIS_REPO]"
cd ${BASE_PATH}/training/LLaMA-Factory-main
# pip install -e ".[torch,metrics,deepspeed]"
$BIN="[PATH_TO_YOUR_ENV]"
# eg. bulabula/envs/llamafctory/bin

export TOKENIZERS_PARALLELISM=flase
export CUDA_VISIBLE_DEVICES=0,1,2,3

export WANDB_API_KEY="[YOUR_KEY]"
wandb login --relogin $WANDB_API_KEY
export WANDB_PROJECT="Experiments_Short2Long"

BASE_MODEL="Qwen2.5-7B-Instruct"
CONFIG_NAME_LIST=("s2l_dpo_8k_s2l_chosen_sft_qwen" "s2l_orpo_8k_s2l_chosen_sft_qwen" "s2l_simpo_8k_s2l_chosen_sft_qwen")
for CONFIG_NAME in ${CONFIG_NAME_LIST[@]}; do
    CONFIG_PATH="${BASE_PATH}/training/config/${BASE_MODEL}/${CONFIG_NAME}.yaml"
    FORCE_TORCHRUN=1 $BIN/llamafactory-cli train ${CONFIG_PATH}
done