#!/bin/bash

SPLIT="mmbench_dev_20230712"

python -m llava.eval.model_vqa_mmbench \
    --model-base checkpoints/llava-v1.5-7b \
    --model-path checkpoints/llava-v1.5-7b-lora-mohle-si/ \
    --question-file ./playground/data/eval/mmbench/$SPLIT.tsv \
    --answers-file eval-output/mmbench-l2ora-si/answers/$SPLIT/llava-v1.5-l2ora-si.jsonl \
    --single-pred-prompt \
    --temperature 0 \
    --conv-mode vicuna_v1

mkdir -p eval-output/mmbench-l2ora-si/answers_upload/$SPLIT

python scripts/convert_mmbench_for_submission.py \
    --annotation-file ./playground/data/eval/mmbench/$SPLIT.tsv \
    --result-dir eval-output/mmbench-l2ora-si/answers/$SPLIT \
    --upload-dir eval-output/mmbench-l2ora-si/answers_upload/$SPLIT \
    --experiment llava-v1.5-l2ora-si
