#!/bin/bash


datasets=("piqa" "boolq" "social_i_qa" "hellaswag" "winogrande" "ARC-Challenge" "ARC-Easy" "openbookqa")


for dataset in "${datasets[@]}"; do
    lora_type=cosmos lora_num=3 CUDA_VISIBLE_DEVICES=0 python evaluate.py \
        --model LLaMA3 \
        --adapter LoRA \
        --dataset "$dataset" \
        --save_dir Exp/l2ora-commonsense \
        --batch_size 32 \
        --base_model '/Meta-Llama-3-8B' \
        --lora_weights '/sft-out/l2ora'
done