import os
import json
import argparse

# 解析命令行参数
parser = argparse.ArgumentParser(description="Process all JSON files in folders and merge them.")
parser.add_argument("output_file", type=str, help="Output JSON file name")
args = parser.parse_args()

# 用于存储所有合并后的记录
all_records = []

# 获取当前目录路径
current_dir = os.getcwd()

# 遍历当前目录下的所有文件夹
for folder_name in os.listdir(current_dir):
    folder_path = os.path.join(current_dir, folder_name)
    
    # 确保只处理文件夹
    if os.path.isdir(folder_path):
        # 查找当前文件夹中的所有 JSON 文件
        json_files = [f for f in os.listdir(folder_path) if f.endswith('.json')]
        
        for json_file in json_files:
            json_path = os.path.join(folder_path, json_file)
            
            print(f"Processing dataset from {json_path}")
            
            # 读取 JSON 文件
            with open(json_path, 'r', encoding='utf-8') as f:
                dataset_records = json.load(f)
            if len(dataset_records) > 20 * 1000:
                dataset_records = dataset_records[:20 * 1000]
            # 更新每条记录的 image 字段，添加文件夹路径
            for record in dataset_records:
                if 'image' in record:
                    record['image'] = os.path.join(folder_name, record['image'])  # 加上文件夹路径

            # 将更新后的记录加入总列表
            all_records.extend(dataset_records)

# 输出合并后的数据到指定的 JSON 文件
output_file_path = os.path.join(current_dir, args.output_file)
os.makedirs(os.path.dirname(output_file_path), exist_ok=True)

# 用于存储唯一的 id
seen_ids = set()

# 用于存储最终去重后的数据
unique_data = []

# 遍历每个条目，去除重复的 id
for one in all_records:
    if one['id'] in seen_ids:
        continue  # 跳过重复的 id
    else:
        seen_ids.add(one['id'])  # 添加 id 到 set 中
        unique_data.append(one)  # 保留该条数据

# 输出去重后的数据
print(f"去重后的数据共有 {len(unique_data)} 条")

# 保存去重后的数据为 JSON 文件
with open(output_file_path, 'w', encoding='utf-8') as f:
    json.dump(unique_data, f, ensure_ascii=False, indent=4)

print(f"All datasets have been processed and merged into {output_file_path}")
