#!/bin/bash
export CUDA_LAUNCH_BLOCKING=1
export PYTORCH_CUDA_ALLOC_CONF=max_split_size_mb:128

LOG_FILE="experiment_log_$(date +%Y%m%d_%H%M%S).log"
exec > >(tee -a "$LOG_FILE") 2>&1
echo "Starting experiments at $(date)"

TASKS=(146206 146607 146820 14951 14952 14964 14969 14970 167141 167211 168908 168909 168910 168912 190410 2074 28 32 3481 3510 3686 3711 3735 3889 3896 3897 3904 3950 3954 43 45 9952 9960 9985 9986 9987)
# TASKS=(3889 3896 3897 3904 3950 3954 43 45 9952 9960 9985 9986 9987)
# TASKS=(146206)
MODELS=(
  # "configs/experiments/mlp.yaml"
  # "configs/experiments/imlp.yaml"
  # "configs/experiments/modernnca.yaml"
  # "configs/experiments/realmlp.yaml"
  # "configs/experiments/tabm.yaml"
  "configs/experiments/tabpfnv2.yaml"
  # "configs/experiments/tabr.yaml"
  # "configs/experiments/xgboost.yaml"
  # "configs/experiments/catboost.yaml"
  # "configs/experiments/lightgbm.yaml"
  # "configs/experiments/linear.yaml"
  # "configs/experiments/knn.yaml"
  # "configs/experiments/decisiontree.yaml"
  # "configs/experiments/randomforest.yaml"
  # "configs/experiments/danet.yaml"
  # "configs/experiments/stg.yaml"
  # "configs/experiments/tabnet.yaml"
  # "configs/experiments/vime.yaml"
  # "configs/experiments/svm.yaml"
  # "configs/experiments/resnet.yaml" # switch to python 3.10
  # "configs/experiments/tabpfn.yaml" # Unused
  # "configs/experiments/saint.yaml" # Unused
  # "configs/experiments/fttransformer.yaml" # Unused
  )

SEEDS=(7 42 101)
DEVICE="cuda"

for task in "${TASKS[@]}"; do
  for model in "${MODELS[@]}"; do
    for seed in "${SEEDS[@]}"; do
      # Run with tuning
      # Check if the model is mlp or imlp
      # model_basename=$(basename $model)
      # if [[ "$model_basename" == "mlp.yaml" || "$model_basename" == "imlp.yaml" ]]; then
      #   echo "Running task=$task model=$model_basename seed=$seed (with tuning)"
      #   python src/cli.py --experiment $model --task $task --device $DEVICE --seed $seed
      # fi
      # Run without tuning
      echo "Running task=$task model=$(basename $model) seed=$seed (no tuning)"
      python src/cli.py --experiment $model --task $task --device $DEVICE --seed $seed --no_tuning
    done
  done
done