from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="imlp",
    version="0.1.0",
    author="Anonymous Authors",
    author_email="anonymous@example.com",  # Will be updated after review
    description="Context-Aware Incremental MLP for Energy-Efficient Tabular Learning",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/anonymous/imlp",  # Will be updated after review
    packages=find_packages(include=["src", "src.*"]),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Science/Research",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
    python_requires=">=3.8",
    install_requires=[
        "torch>=1.13.0",
        "numpy>=1.21.0",
        "pandas>=1.3.0",
        "scikit-learn>=1.0.0",
        "matplotlib>=3.5.0",
        "pyyaml>=6.0",
        "pyserial>=3.5",
        "tqdm>=4.60.0",
        "networkx>=2.7.0",
        "openml>=0.12.0",
        "joblib>=1.1.0"
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "jupyter>=1.0.0",
            "seaborn>=0.11.0",
            "optuna>=3.0.0",
        ],
        "baseline_models": [
            "lightgbm>=3.3.0",
            "xgboost>=1.7.0",
            "catboost>=1.1.0",
        ],
    },
    entry_points={
        "console_scripts": [
            "run-imlp=src.cli:main",
        ],
    },
)