#!/bin/bash

for dir in 'amazon_ratings.5' 
do
    if [ ${dir} = "cora.8" ]; then
        dataset="cora"
        emb="simteg"
    elif [ ${dir} = "arxiv" ]; then
        dataset="arxiv"
        emb="simteg"
    elif [ ${dir} = 'roman_empire.5' ]; then
        dataset="roman_empire"
        emb="vicuna"
    elif [ ${dir} = 'amazon_ratings.5' ]; then
        dataset="amazon_ratings"
        emb="vicuna"
    fi
    for transform in "-gdc" "-sgdc" "" 
    do
        for adapter in linear gcn gat gin
        do
            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-${emb}-2-4-${adapter}-1-projector${transform}_nc
            model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
            mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
            dataset=${dataset} #test dataset
            task="nc" #test task
            emb=${emb}
            use_hop=1
            sample_size=4
            template="anti-ND" # or ND
            output_path="./outputs/"
            answers_file=./outputs/${adapter}/nc/${dataset}-1${transform}.json

            # python eval/eval_pretrain_pyg.py \
            # --model_path ${model_path} \
            # --model_base ${model_base} \
            # --conv_mode  ${mode} \
            # --dataset ${dataset} \
            # --pretrained_embedding_type ${emb} \
            # --use_hop ${use_hop} \
            # --sample_neighbor_size ${sample_size} \
            # --answers_file ${answers_file} \
            # --task ${task} \
            # --cache_dir /data/haotian/.cache \
            # --template ${template}

            # wait

            echo -e Test_${dataset}_with_${adapter}${transform}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

            echo -e "-------------------------------"

            wait
        done
    done
done