#!/bin/bash

for dir in  "amazon_ratings"  "school.13" "citeseer.5" "cora.5" "pubmed" "roman_empire"
do
    if [ ${dir} = "cora.5" ]; then
        dataset="cora"
        emb="simteg"
    elif [ ${dir} = "pubmed" ]; then
        dataset="pubmed"
        emb="simteg"
    elif [ ${dir} = 'roman_empire' ]; then
        dataset="roman_empire"
        emb="vicuna"
    elif [ ${dir} = 'amazon_ratings' ]; then
        dataset="amazon_ratings"
        emb="vicuna"
    elif [ ${dir} = 'school.13' ]; then
        dataset="school"
        emb="llmicl_primary"
    elif [ ${dir} = 'citeseer.5' ]; then
        dataset="citeseer"
        emb="llmicl_primary"
    fi
    for seed in 42 3407 114514
    do
        model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-${emb}-1-4-linear-projector_lp_${seed}
        # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-vicuna-7b-simteg-1-linear-1-projector_hp"
        model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
        mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
        dataset=${dataset} #test dataset
        task="lp" #test task
        emb=${emb}
        use_hop=1
        sample_size=4
        template="ND" # or ND
        output_path="./outputs/"
        answers_file=./outputs/ND/lp/${dataset}-seed-${seed}.json

        # python eval/eval_pretrain.py \
        # --model_path ${model_path} \
        # --model_base ${model_base} \
        # --conv_mode  ${mode} \
        # --dataset ${dataset} \
        # --pretrained_embedding_type ${emb} \
        # --use_hop ${use_hop} \
        # --sample_neighbor_size ${sample_size} \
        # --answers_file ${answers_file} \
        # --task ${task} \
        # --cache_dir /data/haotian/.cache \
        # --template ${template}

        # wait

        
        echo -e Test_${dataset}_with_ND_at_seed_${seed}

        python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
        wait

        # model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-anti-${emb}-1-4-linear-projector_lp_${seed}
        # # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-vicuna-7b-simteg-1-linear-1-projector_hp"
        # model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
        # mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
        # dataset=${dataset} #test dataset
        # task="lp" #test task
        # emb=${emb}
        # use_hop=1
        # sample_size=4
        # template="anti-ND" # or ND
        # output_path="./outputs/"
        # answers_file=./outputs/HN1/lp/${dataset}-seed-${seed}.json

        # python eval/eval_pretrain.py \
        # --model_path ${model_path} \
        # --model_base ${model_base} \
        # --conv_mode  ${mode} \
        # --dataset ${dataset} \
        # --pretrained_embedding_type ${emb} \
        # --use_hop ${use_hop} \
        # --sample_neighbor_size ${sample_size} \
        # --answers_file ${answers_file} \
        # --task ${task} \
        # --cache_dir /data/haotian/.cache \
        # --template ${template}

        # wait

        
        # echo -e Test_${dataset}_with_HN1_at_seed_${seed}

        # python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
        # wait

        # model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-HN-${emb}-0-0-linear-projector_lp_${seed}
        # # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-vicuna-7b-simteg-1-linear-1-projector_hp"
        # model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
        # mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
        # dataset=${dataset} #test dataset
        # task="lp" #test task
        # emb=${emb}
        # use_hop=0
        # sample_size=0
        # template="HN" # or ND
        # output_path="./outputs/"
        # answers_file=./outputs/CO/lp/${dataset}-seed-${seed}.json

        # python eval/eval_pretrain.py \
        # --model_path ${model_path} \
        # --model_base ${model_base} \
        # --conv_mode  ${mode} \
        # --dataset ${dataset} \
        # --pretrained_embedding_type ${emb} \
        # --use_hop ${use_hop} \
        # --sample_neighbor_size ${sample_size} \
        # --answers_file ${answers_file} \
        # --task ${task} \
        # --cache_dir /data/haotian/.cache \
        # --template ${template}

        # wait

        
        # echo -e Test_${dataset}_with_CO_at_seed_${seed}

        # python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
        # wait
    done
done

# for dir in "cora.5" #"roman_empire.5" "amazon_ratings.5" 
# do
#     if [ ${dir} = "cora.5" ]; then
#         dataset="cora"
#         emb="simteg"
#     elif [ ${dir} = "arxiv" ]; then
#         dataset="arxiv"
#         emb="simteg"
#     elif [ ${dir} = 'roman_empire.5' ]; then
#         dataset="roman_empire"
#         emb="vicuna"
#     elif [ ${dir} = 'amazon_ratings.5' ]; then
#         dataset="amazon_ratings"
#         emb="vicuna"
#     fi
#     for hop in 1 2 3 4
#     do
#         for adapter in linear gcn gat gin
#         do
#             model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-${emb}-${hop}-${adapter}-1-projector_hp
#             # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-vicuna-7b-simteg-1-linear-1-projector_hp"
#             model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
#             mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
#             dataset=${dataset} #test dataset
#             task="hp" #test task
#             emb=${emb}
#             use_hop=${hop}
#             sample_size=0
#             template="anti-ND" # or ND
#             output_path="./outputs/"
#             answers_file=./outputs/${adapter}/hp/${dataset}-hop-${hop}-1.json

#             # python eval/eval_pretrain_pyg.py \
#             # --model_path ${model_path} \
#             # --model_base ${model_base} \
#             # --conv_mode  ${mode} \
#             # --dataset ${dataset} \
#             # --pretrained_embedding_type ${emb} \
#             # --use_hop ${use_hop} \
#             # --sample_neighbor_size ${sample_size} \
#             # --answers_file ${answers_file} \
#             # --task ${task} \
#             # --cache_dir /data/haotian/.cache \
#             # --template ${template}

#             # wait

            
#             echo -e Test_${dataset}_with_${adapter}_at_hop_${hop}

#             python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
#             wait
#         done
#     done
# done

# wait 

# model_path="/data/haotian/LLaGA/checkpoints/arxiv/llaga-vicuna-7b-HN-simteg-3-4-linear-projector_nc"
# model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
# mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
# dataset="arxiv" #test dataset
# task="nc" #test task
# emb="simteg"
# use_hop=1
# sample_size=4
# template="anti-ND" # or ND
# output_path="./outputs/"
# answers_file="./outputs/nc/arxiv_train_with_HN_3_4_test_with_anti_ND_1_4.json"

# # python eval/eval_pretrain.py \
# # --model_path ${model_path} \
# # --model_base ${model_base} \
# # --conv_mode  ${mode} \
# # --dataset ${dataset} \
# # --pretrained_embedding_type ${emb} \
# # --use_hop ${use_hop} \
# # --sample_neighbor_size ${sample_size} \
# # --answers_file ${answers_file} \
# # --task ${task} \
# # --cache_dir /data/haotian/.cache \
# # --template ${template}

# # wait

# python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

# wait

# model_path="/data/haotian/LLaGA/checkpoints/arxiv/llaga-vicuna-7b-HN-simteg-4-4-linear-projector_nc"
# model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
# mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
# dataset="arxiv" #test dataset
# task="nc" #test task
# emb="simteg"
# use_hop=1
# sample_size=4
# template="anti-ND" # or ND
# output_path="./outputs/"
# answers_file="./outputs/nc/arxiv_train_with_HN_4_4_test_with_anti_ND_1_4.json"

# # python eval/eval_pretrain.py \
# # --model_path ${model_path} \
# # --model_base ${model_base} \
# # --conv_mode  ${mode} \
# # --dataset ${dataset} \
# # --pretrained_embedding_type ${emb} \
# # --use_hop ${use_hop} \
# # --sample_neighbor_size ${sample_size} \
# # --answers_file ${answers_file} \
# # --task ${task} \
# # --cache_dir /data/haotian/.cache \
# # --template ${template}

# # wait

# python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

# wait

# model_path="/data/haotian/LLaGA/checkpoints/arxiv/llaga-vicuna-7b-simteg-1-4-linear-projector_lp"
# model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
# mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
# dataset="arxiv" #test dataset
# task="lp" #test task
# emb="simteg"
# use_hop=1
# sample_size=4
# template="ND" # or ND
# output_path="./outputs/"
# answers_file="./outputs/lp/arxiv_ND_1_4.json"

# python eval/eval_pretrain.py \
# --model_path ${model_path} \
# --model_base ${model_base} \
# --conv_mode  ${mode} \
# --dataset ${dataset} \
# --pretrained_embedding_type ${emb} \
# --use_hop ${use_hop} \
# --sample_neighbor_size ${sample_size} \
# --answers_file ${answers_file} \
# --task ${task} \
# --cache_dir /data/haotian/.cache \
# --template ${template}

# wait

# python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

# wait

# model_path="/data/haotian/LLaGA/checkpoints/products/llaga-vicuna-7b-anti-simteg-1-4-linear-projector_lp"
# model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
# mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
# dataset="products" #test dataset
# task="lp" #test task
# emb="simteg"
# use_hop=1
# sample_size=4
# template="anti-ND" # or ND
# output_path="./outputs/"
# answers_file="./outputs/lp/products_anti_ND_1_4.json"

# python eval/eval_pretrain.py \
# --model_path ${model_path} \
# --model_base ${model_base} \
# --conv_mode  ${mode} \
# --dataset ${dataset} \
# --pretrained_embedding_type ${emb} \
# --use_hop ${use_hop} \
# --sample_neighbor_size ${sample_size} \
# --answers_file ${answers_file} \
# --task ${task} \
# --cache_dir /data/haotian/.cache \
# --template ${template}

# wait

# python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

# wait

# model_path="/data/haotian/LLaGA/checkpoints/products/llaga-vicuna-7b-anti-simteg-1-4-linear-projector_nc"
# model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
# mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
# dataset="products" #test dataset
# task="nc" #test task
# emb="simteg"
# use_hop=1
# sample_size=4
# template="anti-ND" # or ND
# output_path="./outputs/"
# answers_file="./outputs/nc/products_anti_ND_1_4.json"

# python eval/eval_pretrain.py \
# --model_path ${model_path} \
# --model_base ${model_base} \
# --conv_mode  ${mode} \
# --dataset ${dataset} \
# --pretrained_embedding_type ${emb} \
# --use_hop ${use_hop} \
# --sample_neighbor_size ${sample_size} \
# --answers_file ${answers_file} \
# --task ${task} \
# --cache_dir /data/haotian/.cache \
# --template ${template}

# wait

# python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

# wait

# model_path="/data/haotian/LLaGA/checkpoints/products/llaga-vicuna-7b-simteg-1-4-linear-projector_lp"
# model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
# mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
# dataset="products" #test dataset
# task="lp" #test task
# emb="simteg"
# use_hop=1
# sample_size=4
# template="ND" # or ND
# output_path="./outputs/"
# answers_file="./outputs/lp/products_ND_1_4.json"

# python eval/eval_pretrain.py \
# --model_path ${model_path} \
# --model_base ${model_base} \
# --conv_mode  ${mode} \
# --dataset ${dataset} \
# --pretrained_embedding_type ${emb} \
# --use_hop ${use_hop} \
# --sample_neighbor_size ${sample_size} \
# --answers_file ${answers_file} \
# --task ${task} \
# --cache_dir /data/haotian/.cache \
# --template ${template}

# wait

# python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

# wait

# model_path="/data/haotian/LLaGA/checkpoints/products/llaga-vicuna-7b-simteg-1-4-linear-projector_nc"
# model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
# mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
# dataset="products" #test dataset
# task="nc" #test task
# emb="simteg"
# use_hop=1
# sample_size=4
# template="ND" # or ND
# output_path="./outputs/"
# answers_file="./outputs/nc/products_ND_1_4.json"

# python eval/eval_pretrain.py \
# --model_path ${model_path} \
# --model_base ${model_base} \
# --conv_mode  ${mode} \
# --dataset ${dataset} \
# --pretrained_embedding_type ${emb} \
# --use_hop ${use_hop} \
# --sample_neighbor_size ${sample_size} \
# --answers_file ${answers_file} \
# --task ${task} \
# --cache_dir /data/haotian/.cache \
# --template ${template}

# wait

# python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}

# wait