#!/bin/bash

model_path="/data/haotian/LLaGA/checkpoints/arxiv-pubmed/llaga-vicuna-7b-negative-simteg-2-10-linear-projector_lp"
model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
dataset="pubmed" #test dataset
task="lp" #test task
emb="negative-simteg"
use_hop=2
sample_size=10
template="ND" # or ND
output_path="./outputs/"
answers_file="./outputs/negative-pubmed-train-ND-lp.json"

python eval/eval_pretrain.py \
--model_path ${model_path} \
--model_base ${model_base} \
--conv_mode  ${mode} \
--dataset ${dataset} \
--pretrained_embedding_type ${emb} \
--use_hop ${use_hop} \
--sample_neighbor_size ${sample_size} \
--answers_file ${answers_file} \
--task ${task} \
--cache_dir /data/haotian/.cache \
--template ${template} \
--use_negative \
--use_train

wait

python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}