#!/bin/bash

for dir in "amazon_ratings" 
do
    if [ ${dir} = "cora.5" ]; then
        dataset="cora"
        emb="simteg"
    elif [ ${dir} = "pubmed" ]; then
        dataset="pubmed"
        emb="simteg"
    elif [ ${dir} = 'roman_empire' ]; then
        dataset="roman_empire"
        emb="vicuna"
    elif [ ${dir} = 'amazon_ratings' ]; then
        dataset="amazon_ratings"
        emb="vicuna"
    elif [ ${dir} = 'school.13' ]; then
        dataset="school"
        emb="llmicl_primary"
    elif [ ${dir} = 'citeseer.5' ]; then
        dataset="citeseer"
        emb="llmicl_primary"
    fi
    for seed in 114514
    do
        # model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-${emb}-1-4-linear-projector_nc_${seed}
        # # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-vicuna-7b-simteg-1-linear-1-projector_hp"
        # model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
        # mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
        # dataset=${dataset} #test dataset
        # task="nc" #test task
        # emb=${emb}
        # use_hop=1
        # sample_size=4
        # template="ND" # or ND
        # output_path="./outputs/"
        # answers_file=./outputs/ND/nc/${dataset}-seed-${seed}.json

        # python eval/eval_pretrain.py \
        # --model_path ${model_path} \
        # --model_base ${model_base} \
        # --conv_mode  ${mode} \
        # --dataset ${dataset} \
        # --pretrained_embedding_type ${emb} \
        # --use_hop ${use_hop} \
        # --sample_neighbor_size ${sample_size} \
        # --answers_file ${answers_file} \
        # --task ${task} \
        # --cache_dir /data/haotian/.cache \
        # --template ${template}

        # wait

        
        # echo -e Test_${dataset}_with_ND_at_seed_${seed}

        # python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
        # wait

        model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-anti-${emb}-1-4-linear-projector_nc_${seed}
        # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-vicuna-7b-simteg-1-linear-1-projector_hp"
        model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
        mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
        dataset=${dataset} #test dataset
        task="nc" #test task
        emb=${emb}
        use_hop=1
        sample_size=4
        template="anti-ND" # or ND
        output_path="./outputs/"
        answers_file=./outputs/HN1/nc/${dataset}-seed-${seed}.json

        python eval/eval_pretrain.py \
        --model_path ${model_path} \
        --model_base ${model_base} \
        --conv_mode  ${mode} \
        --dataset ${dataset} \
        --pretrained_embedding_type ${emb} \
        --use_hop ${use_hop} \
        --sample_neighbor_size ${sample_size} \
        --answers_file ${answers_file} \
        --task ${task} \
        --cache_dir /data/haotian/.cache \
        --template ${template}

        wait

        
        echo -e Test_${dataset}_with_HN1_at_seed_${seed}

        python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
        # wait

        # model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-vicuna-7b-HN-${emb}-0-0-linear-projector_nc_${seed}
        # # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-vicuna-7b-simteg-1-linear-1-projector_hp"
        # model_base="lmsys/vicuna-7b-v1.5-16k" #meta-llama/Llama-2-7b-hf
        # mode="v1" # use 'llaga_llama_2' for llama and "v1" for others
        # dataset=${dataset} #test dataset
        # task="nc" #test task
        # emb=${emb}
        # use_hop=0
        # sample_size=0
        # template="HN" # or ND
        # output_path="./outputs/"
        # answers_file=./outputs/CO/nc/${dataset}-seed-${seed}.json

        # python eval/eval_pretrain.py \
        # --model_path ${model_path} \
        # --model_base ${model_base} \
        # --conv_mode  ${mode} \
        # --dataset ${dataset} \
        # --pretrained_embedding_type ${emb} \
        # --use_hop ${use_hop} \
        # --sample_neighbor_size ${sample_size} \
        # --answers_file ${answers_file} \
        # --task ${task} \
        # --cache_dir /data/haotian/.cache \
        # --template ${template}

        # wait

        
        # echo -e Test_${dataset}_with_CO_at_seed_${seed}

        # python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
        # wait
    done
done