#!/bin/bash
for task in nc lp
do
    for dir in "cora.5"
    do
        if [ ${dir} = "cora.5" ]; then
            dataset="cora"
            emb="simteg"
        elif [ ${dir} = "pubmed" ]; then
            dataset="pubmed"
            emb="simteg"
        elif [ ${dir} = 'roman_empire' ]; then
            dataset="roman_empire"
            emb="vicuna"
        elif [ ${dir} = 'amazon_ratings' ]; then
            dataset="amazon_ratings"
            emb="vicuna"
        elif [ ${dir} = 'school.13' ]; then
            dataset="school"
            emb="llmicl_primary"
        elif [ ${dir} = 'citeseer.5' ]; then
            dataset="citeseer"
            emb="llmicl_primary"
        fi
        for seed in 42 3407 114514
        do
            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-llama-2-7b-hf-${emb}-1-4-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-llama-2-7b-hf-simteg-1-linear-1-projector_hp"
            model_base="meta-llama/Llama-2-7b-hf" #meta-llama/Llama-2-7b-hf
            mode="llaga_llama_2" # use 'llaga_llama_2' for llama and "llaga_llama_2" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=1
            sample_size=4
            template="ND" # or ND
            output_path="./outputs/"
            answers_file=./outputs/ND/${task}/llama_7b_${dataset}-seed-${seed}-debug.json

            python eval/eval_pretrain.py \
            --model_path ${model_path} \
            --model_base ${model_base} \
            --conv_mode  ${mode} \
            --dataset ${dataset} \
            --pretrained_embedding_type ${emb} \
            --use_hop ${use_hop} \
            --sample_neighbor_size ${sample_size} \
            --answers_file ${answers_file} \
            --task ${task} \
            --cache_dir /data/haotian/.cache \
            --template ${template}
            exit
            # wait

            
            echo -e Test_${dataset}_on_${task}_with_ND_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait

            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-llama-2-7b-hf-anti-${emb}-1-4-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-llama-2-7b-hf-simteg-1-linear-1-projector_hp"
            model_base="meta-llama/Llama-2-7b-hf" #meta-llama/Llama-2-7b-hf
            mode="llaga_llama_2" # use 'llaga_llama_2' for llama and "llaga_llama_2" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=1
            sample_size=4
            template="anti-ND" # or ND
            output_path="./outputs/"
            answers_file=./outputs/HN1/${task}/llama_7b_${dataset}-seed-${seed}.json

            # python eval/eval_pretrain.py \
            # --model_path ${model_path} \
            # --model_base ${model_base} \
            # --conv_mode  ${mode} \
            # --dataset ${dataset} \
            # --pretrained_embedding_type ${emb} \
            # --use_hop ${use_hop} \
            # --sample_neighbor_size ${sample_size} \
            # --answers_file ${answers_file} \
            # --task ${task} \
            # --cache_dir /data/haotian/.cache \
            # --template ${template}

            # wait

            
            echo -e Test_${dataset}_on_${task}_with_HN1_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait

            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-llama-2-7b-hf-HN-${emb}-0-0-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-llama-2-7b-hf-simteg-1-linear-1-projector_hp"
            model_base="meta-llama/Llama-2-7b-hf" #meta-llama/Llama-2-7b-hf
            mode="llaga_llama_2" # use 'llaga_llama_2' for llama and "llaga_llama_2" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=0
            sample_size=0
            template="HN" # or ND
            output_path="./outputs/"
            answers_file=./outputs/CO/${task}/llama_7b_${dataset}-seed-${seed}.json

            # python eval/eval_pretrain.py \
            # --model_path ${model_path} \
            # --model_base ${model_base} \
            # --conv_mode  ${mode} \
            # --dataset ${dataset} \
            # --pretrained_embedding_type ${emb} \
            # --use_hop ${use_hop} \
            # --sample_neighbor_size ${sample_size} \
            # --answers_file ${answers_file} \
            # --task ${task} \
            # --cache_dir /data/haotian/.cache \
            # --template ${template}

            # wait

            
            echo -e Test_${dataset}_on_${task}_with_CO_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait
        done
    done
done