#!/bin/bash

#   use_hop=1
#   template="ND"
#   projector_type="linear"
#   prefix=llaga-nemotron-7B-instruct-${emb}-${use_hop}-${sample_size}-${projector_type}-projector
#   model_base=Nvidia/OpenReasoning-NEMOTRON-7B
#   mode="llaga_nemotron"
# elif [ ${model} = "nemotron" ]; then
#   use_hop=1
#   template="ND"
#   projector_type="linear"
#   prefix=llaga-nemotron-7b-${emb}-${use_hop}-${sample_size}-${projector_type}-projector
#   model_base=nvidia/OpenReasoning-Nemotron-7B
#   mode="llaga_nemotron"

for task in nc #lp
do
    for dir in  citeseer.5
    do
        if [ ${dir} = "cora.5" ]; then
            dataset="cora"
            emb="simteg"
        elif [ ${dir} = "pubmed" ]; then
            dataset="pubmed"
            emb="simteg"
        elif [ ${dir} = 'roman_empire' ]; then
            dataset="roman_empire"
            emb="vicuna"
        elif [ ${dir} = 'amazon_ratings' ]; then
            dataset="amazon_ratings"
            emb="vicuna"
        elif [ ${dir} = 'school.13' ]; then
            dataset="school"
            emb="llmicl_primary"
        elif [ ${dir} = 'citeseer.5' ]; then
            dataset="citeseer"
            emb="llmicl_primary"
        fi
        for seed in 42 3407 114514
        do
            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-nemotron-7b-${emb}-1-4-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-nemotron-7b-instruct-simteg-1-linear-1-projector_hp"
            model_base="nvidia/OpenReasoning-Nemotron-7B" #nvidia/OpenReasoning-NEMOTRON-7B
            mode="llaga_nemotron" # use 'llaga_nemotron' for qwen and "llaga_nemotron" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=1
            sample_size=4
            template="ND" # or ND
            output_path="./outputs/"
            answers_file=./outputs/ND/${task}/nemotron_7b_${dataset}-seed-${seed}.json

            python eval/eval_pretrain.py \
            --model_path ${model_path} \
            --model_base ${model_base} \
            --conv_mode  ${mode} \
            --dataset ${dataset} \
            --pretrained_embedding_type ${emb} \
            --use_hop ${use_hop} \
            --sample_neighbor_size ${sample_size} \
            --answers_file ${answers_file} \
            --task ${task} \
            --cache_dir /data/haotian/.cache \
            --template ${template}

            wait

            
            echo -e Test_${dataset}_on_${task}_with_ND_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait

            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-nemotron-7b-anti-${emb}-1-4-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-nemotron-7b-instruct-simteg-1-linear-1-projector_hp"
            model_base="nvidia/OpenReasoning-Nemotron-7B" #nvidia/OpenReasoning-NEMOTRON-7B
            mode="llaga_nemotron" # use 'llaga_nemotron' for qwen and "llaga_nemotron" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=1
            sample_size=4
            template="anti-ND" # or ND
            output_path="./outputs/"
            answers_file=./outputs/HN1/${task}/nemotron_7b_${dataset}-seed-${seed}.json

            python eval/eval_pretrain.py \
            --model_path ${model_path} \
            --model_base ${model_base} \
            --conv_mode  ${mode} \
            --dataset ${dataset} \
            --pretrained_embedding_type ${emb} \
            --use_hop ${use_hop} \
            --sample_neighbor_size ${sample_size} \
            --answers_file ${answers_file} \
            --task ${task} \
            --cache_dir /data/haotian/.cache \
            --template ${template}

            wait

            
            echo -e Test_${dataset}_on_${task}_with_HN1_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait

            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-nemotron-7b-HN-${emb}-0-0-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-nemotron-7b-instruct-simteg-1-linear-1-projector_hp"
            model_base="nvidia/OpenReasoning-Nemotron-7B" #nvidia/OpenReasoning-NEMOTRON-7B
            mode="llaga_nemotron" # use 'llaga_nemotron' for qwen and "llaga_nemotron" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=0
            sample_size=0
            template="HN" # or ND
            output_path="./outputs/"
            answers_file=./outputs/CO/${task}/nemotron_7b_${dataset}-seed-${seed}.json

            python eval/eval_pretrain.py \
            --model_path ${model_path} \
            --model_base ${model_base} \
            --conv_mode  ${mode} \
            --dataset ${dataset} \
            --pretrained_embedding_type ${emb} \
            --use_hop ${use_hop} \
            --sample_neighbor_size ${sample_size} \
            --answers_file ${answers_file} \
            --task ${task} \
            --cache_dir /data/haotian/.cache \
            --template ${template}

            wait

            
            echo -e Test_${dataset}_on_${task}_with_CO_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait
        done
    done
done