#!/bin/bash

#   use_hop=1
#   template="ND"
#   projector_type="linear"
#   prefix=llaga-qwen2.5-7B-instruct-${emb}-${use_hop}-${sample_size}-${projector_type}-projector
#   model_base=Qwen/Qwen2.5-7B-Instruct
#   mode="llaga_qwen"
# elif [ ${model} = "nemotron" ]; then
#   use_hop=1
#   template="ND"
#   projector_type="linear"
#   prefix=llaga-nemotron-7b-${emb}-${use_hop}-${sample_size}-${projector_type}-projector
#   model_base=nvidia/OpenReasoning-Nemotron-7B
#   mode="llaga_qwen"

for task in nc #lp
do
    for dir in  cora.5 school.13 # citeseer.5
    do
        if [ ${dir} = "cora.5" ]; then
            dataset="cora"
            emb="simteg"
        elif [ ${dir} = "pubmed" ]; then
            dataset="pubmed"
            emb="simteg"
        elif [ ${dir} = 'roman_empire' ]; then
            dataset="roman_empire"
            emb="vicuna"
        elif [ ${dir} = 'amazon_ratings' ]; then
            dataset="amazon_ratings"
            emb="vicuna"
        elif [ ${dir} = 'school.13' ]; then
            dataset="school"
            emb="llmicl_primary"
        elif [ ${dir} = 'citeseer.5' ]; then
            dataset="citeseer"
            emb="llmicl_primary"
        fi
        for seed in 42 3407 114514
        do
            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-qwen2.5-7b-instruct-${emb}-1-4-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-qwen2.5-7b-instruct-simteg-1-linear-1-projector_hp"
            model_base="Qwen/Qwen2.5-7B-Instruct" #qwen/Qwen2.5-7B-Instruct
            mode="llaga_qwen" # use 'llaga_qwen' for qwen and "llaga_qwen" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=1
            sample_size=4
            template="ND" # or ND
            output_path="./outputs/"
            answers_file=./outputs/ND/${task}/qwen_7b_${dataset}-seed-${seed}.json

            python eval/eval_pretrain.py \
            --model_path ${model_path} \
            --model_base ${model_base} \
            --conv_mode  ${mode} \
            --dataset ${dataset} \
            --pretrained_embedding_type ${emb} \
            --use_hop ${use_hop} \
            --sample_neighbor_size ${sample_size} \
            --answers_file ${answers_file} \
            --task ${task} \
            --cache_dir /data/haotian/.cache \
            --template ${template}

            wait

            
            echo -e Test_${dataset}_on_${task}_with_ND_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait

            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-qwen2.5-7b-instruct-anti-${emb}-1-4-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-qwen2.5-7b-instruct-simteg-1-linear-1-projector_hp"
            model_base="Qwen/Qwen2.5-7B-Instruct" #qwen/Qwen2.5-7B-Instruct
            mode="llaga_qwen" # use 'llaga_qwen' for qwen and "llaga_qwen" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=1
            sample_size=4
            template="anti-ND" # or ND
            output_path="./outputs/"
            answers_file=./outputs/HN1/${task}/qwen_7b_${dataset}-seed-${seed}.json

            python eval/eval_pretrain.py \
            --model_path ${model_path} \
            --model_base ${model_base} \
            --conv_mode  ${mode} \
            --dataset ${dataset} \
            --pretrained_embedding_type ${emb} \
            --use_hop ${use_hop} \
            --sample_neighbor_size ${sample_size} \
            --answers_file ${answers_file} \
            --task ${task} \
            --cache_dir /data/haotian/.cache \
            --template ${template}

            wait

            
            echo -e Test_${dataset}_on_${task}_with_HN1_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait

            model_path=/data/haotian/LLaGA/checkpoints/${dir}/llaga-qwen2.5-7b-instruct-HN-${emb}-0-0-linear-projector_${task}_${seed}
            # model_path="/data/haotian/LLaGA/checkpoints/cora.10/llaga-qwen2.5-7b-instruct-simteg-1-linear-1-projector_hp"
            model_base="Qwen/Qwen2.5-7B-Instruct" #qwen/Qwen2.5-7B-Instruct
            mode="llaga_qwen" # use 'llaga_qwen' for qwen and "llaga_qwen" for others
            dataset=${dataset} #test dataset
            emb=${emb}
            use_hop=0
            sample_size=0
            template="HN" # or ND
            output_path="./outputs/"
            answers_file=./outputs/CO/${task}/qwen_7b_${dataset}-seed-${seed}.json

            python eval/eval_pretrain.py \
            --model_path ${model_path} \
            --model_base ${model_base} \
            --conv_mode  ${mode} \
            --dataset ${dataset} \
            --pretrained_embedding_type ${emb} \
            --use_hop ${use_hop} \
            --sample_neighbor_size ${sample_size} \
            --answers_file ${answers_file} \
            --task ${task} \
            --cache_dir /data/haotian/.cache \
            --template ${template}

            wait

            
            echo -e Test_${dataset}_on_${task}_with_CO_at_seed_${seed}

            python eval/eval_res.py --dataset ${dataset} --task ${task}  --res_path ${answers_file}
            wait
        done
    done
done