#!/bin/bash

# Path to your config file
CONFIG_FILE="baselines/QLearning/config/config.yaml"

# Loop over seeds from 2 to 9
for seed in {0..9}
do
  # Modify the SEED value in the config.yaml file
  sed -i "s/SEED: [0-9]\+/SEED: $seed/" $CONFIG_FILE

  # Loop over config IDs
  for id in 2
  do
    # Run the Python script with the modified config file
    python baselines/QLearning/iql_gnn_eval.py +alg=ql_rnn_mpe_config_${id} CONFIG_ID=${id} SEED=${seed}
  done
done
