import numpy as np
import os
from gym import utils
from gym.envs.mujoco import mujoco_env
from envs.ml_wrapper_env import MetaLearningEnv


class AntMovementEnv(mujoco_env.MujocoEnv, utils.EzPickle, MetaLearningEnv):
    max_tasks = 2

    def __init__(self,  exclude_envs=()):
        envs_to_sample = tuple([i for i in range(AntMovementEnv.max_tasks) if i not in exclude_envs])
        MetaLearningEnv.__init__(self, envs_to_sample=envs_to_sample)
        mujoco_env.MujocoEnv.__init__(self, os.path.dirname(__file__) + '/assets/ant_v2.xml', 5)
        utils.EzPickle.__init__(self)
        self.set_task(self.sample_task())

    def step(self, a):
        # print(self.data.qpos.shape)
        xposbefore = self.data.qpos[0] if self.task == 0 else self.data.qpos[1]
        yposbefore = self.data.qpos[1] if self.task == 0 else self.data.qpos[0]

        self.do_simulation(a, self.frame_skip)

        xposafter = self.data.qpos[0] if self.task == 0 else self.data.qpos[1]
        yposafter = self.data.qpos[1] if self.task == 0 else self.data.qpos[0]

        forward_reward = (xposafter - xposbefore)/self.dt
        # if self.realgoal[0] == 1 or self.realgoal[0] == 3:
            # forward_reward = forward_reward * -1
        side_reward = np.abs(yposafter) * 0.5
        ctrl_cost = .1 * np.square(a).sum()
        reward = forward_reward - ctrl_cost - side_reward
        done = False
        ob = self._get_obs()
        return ob, reward, done, dict(forward_reward=forward_reward, ctrl_cost=ctrl_cost, side_reward=side_reward)

    def _get_obs(self):
        return np.concatenate([
            self.data.qpos.flat,
            self.data.qvel.flat,
        ])

    def set_task(self, task):
        if task >= self.n_envs:
            raise NotImplementedError
        self.task = task

    def reset_model(self):
        qpos = self.init_qpos + np.random.uniform(size=self.model.nq, low=-.1, high=.1)
        qvel = self.init_qvel + np.random.randn(self.model.nv) * .1
        self.set_state(qpos, qvel)
        return self._get_obs()

    def viewer_setup(self):
        self.viewer.cam.distance = self.model.stat.extent * 1.2
