#!/bin/bash

envs=(0 1 2 3 4 5 6 7 8)
export PYTHONPATH=$PYTHONPATH:/home/david/Projects/master_thesis/mlsh/gym;
export PYTHONPATH=$PYTHONPATH:/home/david/Projects/master_thesis/mlsh/rl-algs;

AGENT=AntAgentNoResetContinue;
SEED=45
LOADDIR="../../run_data/paper_experiments/ant_maze/noreset/mlsh/pretrain/${AGENT}${SEED}";
EVALSAVEDIR="../../run_data/paper_experiments/ant_maze/noreset/mlsh/eval/${AGENT}${SEED}";

mkdir $EVALSAVEDIR
for env in "${envs[@]}"; do
    python main.py --task AntObstaclesGenNoReset-v1 --num_subs 3 --macro_duration 200 --num_rollouts 2000 --warmup_time 101 --train_time 0  $AGENT${SEED} --replay False --continue_iter 00030 \
    --fixed_task $env  --loaddir $LOADDIR --iter 1;
    # "../logs/${AGENT}${SEED}/tb/"*
    mkdir "$EVALSAVEDIR/env${env}";
    cp "../logs/${AGENT}${SEED}/tb/"* "$EVALSAVEDIR/env${env}/events.out.tfevents.env${env}";
    rm -r "../logs/${AGENT}${SEED}";
done
