#!/bin/bash

envs=(0 4 8 13 17 21 26 30 34 39 43 47)
export PYTHONPATH=$PYTHONPATH:/home/david/Projects/master_thesis/mlsh/gym;
export PYTHONPATH=$PYTHONPATH:/home/david/Projects/master_thesis/mlsh/rl-algs;

AGENT=TaxiAgent;
SEED=46
MACRODURATION=4
LOADDIR="../../run_data/paper_experiments/taxi_1500/mlsh/macro${MACRODURATION}/pretrain/${AGENT}${MACRODURATION}_${SEED}";
EVALSAVEDIR="../../run_data/paper_experiments/taxi_1500/mlsh/macro${MACRODURATION}/eval/${AGENT}${SEED}";

mkdir $EVALSAVEDIR
for env in "${envs[@]}"; do
    python main.py --task TaxiCustom-v0 --num_subs 4 --macro_duration ${MACRODURATION} --num_rollouts 3000 --warmup_time 101 --train_time 0 $AGENT${SEED} --replay False --continue_iter 00050\
    --fixed_task $env --loaddir $LOADDIR --iter 1 --num_hid 0 --seed ${SEED}
    # "../logs/${AGENT}${SEED}/tb/"*
    mkdir "$EVALSAVEDIR/env${env}";
    cp "../logs/${AGENT}${SEED}/tb/"* "$EVALSAVEDIR/env${env}/events.out.tfevents.env${env}";
    rm -r "../logs/${AGENT}${SEED}";
done
