#!/bin/bash
seeds=(42)
opts=3
lookaheads=0
grad_update_type="single"
env_name="ant_maze_noreset"
baseline="linear"
current_time=$(date "+%Y-%m-%d_%H-%M-%S")
run_name_prefix="run_eval"
BASEDIR=$(dirname $0)
run_data_dir="$BASEDIR/../../run_data/${run_name}"
#envs=(0 1 2 3 4 5 6 7 8)
envs=(3)
for seed in "${seeds[@]}"; do
    chp=$BASEDIR/../../run_data/ant_maze/run_meta_${env_name}_${opts}_*_${seed}_*/checkpoints/*.tar
    for env in "${envs[@]}"; do
        run_name=${run_name_prefix}_${grad_update_type}_${env_name}_${opts}_${env}_${seed}_${current_time}
        log_dir="${run_data_dir}/${run_name}/logs/"
        conda run -n fahp \
        python -u main.py --baseline $baseline --seed $seed --env $env_name --run_name $run_name --epochs 11 --run_data_dir ${run_data_dir} --envs_per_process 1 --episodes 20\
        --fixed_env $env --gae_discount 0.98 --lookaheads $lookaheads --dice_discount 0 --grad_update_type $grad_update_type --return_discount 0.99 --learn_lr_inner --max_option_prob 1\
        --load_chp $chp  --learn_params inner --plot_freq 5000 --chp_freq 10 --fixed_std 0 --save_trajs 
    done
done

