#!/bin/bash

seeds=(142)
opts=3
lookaheads=2
grad_update_type="meta"
env="ant_maze_noreset"
baseline="linear"
current_time=$(date "+%Y-%m-%d_%H-%M-%S")
run_name_prefix="run"
BASEDIR=$(dirname $0)
for seed in "${seeds[@]}"; do
    run_name=${run_name_prefix}_${grad_update_type}_${env}_${opts}_${lookaheads}_${seed}_${current_time}
    log_dir="$BASEDIR/../../run_data/${run_name}/logs/"
    conda run -n fahp mpiexec -np 48 -prepend-rank -outfile-pattern "${log_dir}stdout.txt" -errfile-pattern "${log_dir}stderr.txt" \
    python -u main.py --baseline $baseline --seed $seed --env $env --run_name $run_name --run_data_dir "$BASEDIR/../../run_data"  --epochs 10000 --envs_per_process 1 --episodes 20 \
    --options $opts --gae_discount 0.98 --lr_inner 0.001 --lookaheads $lookaheads --dice_discount 0 --lr_outer 0.001 --grad_update_type $grad_update_type\
    --hidden_sizes_option 64 64 --hidden_sizes_termination 64 64 --hidden_sizes_subpolicy 64 64 --return_discount 0.99 --fixed_std 0 --learn_params outer --learn_lr_inner --max_option_prob 1
done
