#!/bin/bash

. /etc/bashrc
seeds=42
opts=4
lookaheads=0
grad_update_type="single"
env_name="taxi"
baseline="linear"
current_time=$(date "+%Y-%m-%d_%H-%M-%S")
run_name_prefix="eval_multi"
env=0
#envs=(0 4 8 13 17 21 26 30 34 39 43 47)
BASEDIR=$(dirname $0)
chp=$BASEDIR../../run_data/pretrain_multi_${env_name}_${opts}_*_${seed}_*/checkpoints/epoch2000.tar
run_name=${run_name_prefix}_${env_name}_${opts}_${seed}_${env}_${current_time}
log_dir="$BASEDIR/../../run_data/${run_name}/logs/"
conda run -n fahp mpiexec -np 1 -prepend-rank -outfile-pattern "${log_dir}stdout.txt" -errfile-pattern "${log_dir}stderr.txt" \
python -u main.py --baseline linear --seed $seed --env taxi --run_name $run_name --epochs 500 --envs_per_process 1 --episodes 10 --options $opts\
--fixed_env $env --gae_discount 0.98 --lr_inner 1 --lookaheads 0 --dice_discount 0 --entropy_reg 0 --grad_update_type single \
--load_chp $chp --learn_params inner --plot_freq 5000 --chp_freq 500 --run_data_dir "$BASEDIR/../../run_data"

