#!/bin/bash

. /etc/bashrc
seed=42
opts=4
lookaheads=3
grad_update_type="multi"
env_name="taxi"
baseline="linear"
current_time=$(date "+%Y-%m-%d_%H-%M-%S")
run_name_prefix="pretrain"
BASEDIR=$(dirname $0)
run_name=${run_name_prefix}_${grad_update_type}_${env_name}_${opts}_${lookaheads}_${seed}_${current_time}
log_dir="$BASEDIR/../../run_data/${run_name}/logs/"
conda run -n fahp mpiexec -np 48 -prepend-rank -outfile-pattern "${log_dir}stdout.txt" -errfile-pattern "${log_dir}stderr.txt" \
python -u main.py --baseline $baseline --seed $seed --env $env_name --run_name $run_name --run_data_dir "$BASEDIR/../../run_data"  --epochs 2000 --envs_per_process 1 --episodes 1 \
--options $opts --gae_discount 0.98 --lr_inner 1 --lookaheads $lookaheads --dice_discount 0 --lr_outer 0.01 --grad_update_type $grad_update_type --termination_prior 0.5 --no_bias --learn_params all --chp_freq 50 --random_move_prob 0 --exclude_envs 0 4 8 13 17 21 26 30 34 39 43 47 --return_discount 0.95 --max_option_prob 1
