#!/bin/bash

seed=(42)
opts=4
lookaheads=0
grad_update_type="single"
env_name="taxi"
baseline="linear"
current_time=$(date "+%Y-%m-%d_%H-%M-%S")
run_name_prefix="run"
#envs=(0 4 8 13 17 21 26 30 34 39 43 47)
env=0
BASEDIR=$(dirname $0)
run_name=${run_name_prefix}_${grad_update_type}_${env_name}_${opts}_${seed}_${env}_${current_time}
log_dir="$BASEDIR/../../run_data/${run_name}/logs/"
conda run -n fahp \
python -u main.py --baseline $baseline --seed $seed --env $env_name --run_name ${run_name} --run_data_dir "$BASEDIR/../../run_data"  --epochs 500 --envs_per_process 1 --episodes 10 --options $opts --gae_discount 0.98 --lr_outer 0.3 --lookaheads $lookaheads --dice_discount 0 --grad_update_type $grad_update_type --termination_prior 0.5 --no_bias --learn_params all --chp_freq 500 --random_move_prob 0 --plot_freq 5000 --return_discount 0.95 --max_option_prob 1 --fixed_env $env

