import pandas as pd
from datasets import load_dataset
import matplotlib.pyplot as plt 
from datasets import Dataset


url_synthetic = "data/truce_synthetic.csv"
url_stock = "data/truce_stock.csv"
url_sushi = "data/sushi.csv"
url_taxosynth = "data/taxosynth.csv"
synthetic = pd.read_csv(url_synthetic).drop(columns=["Unnamed: 0"])                 
stock = pd.read_csv(url_stock).drop(columns=["Unnamed: 0"])                   
sushi  = pd.read_csv(url_sushi).drop(columns=["Unnamed: 0"])                    
taxosynth = pd.read_csv(url_taxosynth).drop(columns=["Unnamed: 0"])                 
os.makedirs("images", exist_ok=True)
os.makedirs("images/synthetic", exist_ok=True)
os.makedirs("images/stock", exist_ok=True)
os.makedirs("images/sushi", exist_ok=True)
os.makedirs("images/taxosynth", exist_ok=True)

for name, df in {
    "synthetic": synthetic,
    "stock": stock,
    "sushi": sushi,
    "taxosynth": taxosynth,
}.items():
    # Add image_path column for each dataset separately
    df["image_path"] = df["idx"].apply(lambda i: os.path.join(base_path,name, f"{name}_{i}.png"))

    for idx, row in df.iterrows():
        series = eval(row['series']) if isinstance(row['series'], str) else row['series']
        plt.figure(figsize=(6, 3))
        plt.plot(series, marker='o')
        plt.title(f"{name} - idx {row['idx']}")
        plt.xlabel("Time Step")
        plt.ylabel("Value")
        plt.grid(True)
        plt.tight_layout()
        plt.savefig(row["image_path"])
        plt.close()

synthetic.to_pickle("Results/synthetic.pickle", index=False)
stock.to_pickle("Results/stock.pickle", index=False)
sushi.to_pickle("Results/sushi.pickle", index=False)
taxosynth.to_pickle("Results/taxosynth.pickle", index=False)