"""Script to visualize test cases by printing out the messages"""

import argparse
import json
import os

from llm_rules import Message


def main():
    parser = argparse.ArgumentParser(description="Visualize test cases")
    parser.add_argument("--test_dir", default="data/systematic/testcases")
    parser.add_argument("--scenario", default=None)
    args = parser.parse_args()
    files = os.listdir(args.test_dir)
    if args.scenario is not None:
        files = [f for f in files if f.startswith(args.scenario)]
    for f in files:
        print("\n" + f)
        with open(os.path.join(args.test_dir, f), "r") as f:
            for l in f.readlines():
                print("=========================================")
                testcase = json.loads(l.strip())
                print(testcase["params"])
                messages = Message.unserialize(testcase["messages"])
                for m in messages:
                    print(m)


if __name__ == "__main__":
    main()
