"""Script to check that all files in logs have 500 steps."""

from argparse import ArgumentParser
import os


def check_suffixes(path):
    """Check that all files in logs have 500 steps."""
    print("PROCESSING:", path)
    for filename in os.listdir(path):
        if os.path.isdir(os.path.join(path, filename)):
            check_suffixes(os.path.join(path, filename))
        if filename.endswith(".jsonl"):
            with open(os.path.join(path, filename), "r") as f:
                lines = f.readlines()
            if len(lines) != 500:
                print("ERROR:", filename, "has", len(lines), "lines")


def main():
    """Parse arguments and run script."""
    parser = ArgumentParser()
    parser.add_argument("path", help="Path to directory of files to check.")
    args = parser.parse_args()
    check_suffixes(args.path)


if __name__ == "__main__":
    main()
