from .scenario import BaseScenario
from .security import (
    Encryption,
    Integrity,
    AccessControl,
    Commitment,
    Confidentiality,
    Authentication,
    Millionaires,
    DiningCryptographers,
)

from .games import (
    Hodor,
    ForbiddenWord,
    RockPaperScissors,
    AnimalSounds,
    Questions,
    BinarySearch,
    SimonSays,
)

SCENARIO_CLASSES = [
    Encryption,
    Integrity,
    AccessControl,
    Commitment,
    Confidentiality,
    Authentication,
    Millionaires,
    DiningCryptographers,
    Hodor,
    ForbiddenWord,
    RockPaperScissors,
    AnimalSounds,
    Questions,
    BinarySearch,
    SimonSays,
]

SCENARIOS = {s.__name__: s for s in SCENARIO_CLASSES}
