
# Introduction

This serves as the supplementary information for the paper "Geometric
Attention for Small Point Clouds." Scripts for model training and
analysis are provided, as well as trained models.

# Software Environment

Experiments were performed with tensorflow 2.4.1 and python 3.8.5. A
list of python package requirements can be found in
`requirements.txt`:

```
pip install -r requirements.txt
```

# Training scripts

Bash scripts generating flowws workflows to train models are in the
`training` directory.

# Pretrained models

[Getar files](https://libgetar.readthedocs.io) containing trained
model weights and workflow descriptions used to generate them are in
the `data` directory. Models can be loaded using the
[keras-gtar](https://keras-gtar.readthedocs.io/en/latest/) library.

# Analysis scripts

A jupyter notebook that aggregates trained model results and a
Makefile with interactive result visualizations are in the `analysis`
directory.
