#! /bin/bash

#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task 2
#SBATCH --mem=12G
#SBATCH --partition gpu
#SBATCH --time=96:00:00

TARGET="/scratch/scratch_volume1/paper_authors/$(date +%Y%m%d)/structure_identification/${SLURM_JOB_ID}"
mkdir -p "${TARGET}"
cd "$TARGET"

batch_size=64
dim=32
epochs=800

for seed in 41 42 43 44 45;do
    python -m flowws.run -d dump_filename "dump.$(date +%Y%m%d%H%M%S).sqlite" \
           InitializeTF \
           PyriodicDataset --noise 1e-3 5e-2 .1 --structures hP2-Mg cI2-W cF4-Cu cF8-C cF8-SZn cP46-Si cF136-Si cP2-ClCs --size 2048 --num-neighbors 12 --test-fraction .2 --seed $seed \
           CrystalStructureClassification --n-dim $dim --dropout .5 --rank 2 --activation swish --final-activation swish \
           flowws_keras_experimental.Train -e $epochs --batch-size $batch_size --summarize 1 --validation-split 0.3 --seed $((seed+1)) --reduce-lr 20 --reduce-lr-factor .75 --early-stopping 50 \
           flowws_keras_experimental.Save -s 1 -f $seed
done
