
<a name="readme-top"></a>




<br />
<div align="center">

<h3 align="center">Personality Traits in Large Language Models: A Psychometric Evaluation
</h3>


</div>



<!-- TABLE OF CONTENTS -->
<details>
  <summary>Table of Contents</summary>
  <ol>
    <li><a href="#System Requirements">System Requirements</a></li>
    <li><a href="#Original Data">Original Data</a></li>
    <li><a href="#Processed Data Provided to AI">Processed Data Provided to AI</a>
    </li>
    <li>
      <a href="#Complete Communication History between Human Author(s) and AI">Complete Communication History between Human Author(s) and AI</a>
    </li>
    <li><a href="#Finalized Jupyter Notebook based on Code Generated by AI">Finalized Jupyter Notebook based on Code Generated by AI</a></li>
    </li>
  </ol>
</details>



## System Requirements

- Install dependencies according to `./requirements.txt`.
- The finalized executable Jupyter notebook, based on code generated by the AI, can be run on a free-tier Google Colab instance, with a total execution time of under 30 minutes.



## Original Data

The original personality test results on the seven language agents can be found at: https://osf.io/2k458/?view_only=6886694c6f8449488cfbc4e8f78ea2b0, released along with the published paper: [Bodroža, Bojana, et al., 2024](https://royalsocietypublishing.org/doi/10.1098/rsos.240180).


<p align="right">(<a href="#readme-top">back to top</a>)</p>


## Processed Data Provided to AI

Our processed data provided to AI are:

- `data_processed.csv`
- `human_data.csv`
- `variables_explanation.docx`


<p align="right">(<a href="#readme-top">back to top</a>)</p>


## Complete Communication History between Human Author(s) and AI

The complete communication history between human author(s) and AI, including all the prompts, thinking, and responses, is organized in:

- `prompts_and_responses.md`



<p align="right">(<a href="#readme-top">back to top</a>)</p>


## Finalized Jupyter Notebook based on Code Generated by AI

The finalized Jupyter notebook to reproduce our results based on the code generated by AI is:

- `reproducing_results.ipynb`

This finalized version is based on iterations of debugging and improvements carried out primarily by AI, and the full history is also reported in `prompts_and_responses.md`.



<p align="right">(<a href="#readme-top">back to top</a>)</p>


