import torch.nn as nn
class Discriminator(nn.Module):
    def __init__(self,config):
        super(Discriminator,self).__init__()
        self.dynamic_linear = nn.Sequential()

        for i in range(config['number_linear'] - 1):
            self.dynamic_linear.add_module("Linear_" + str(i + 1), nn.Linear(config['features_size'],config['features_size']))
            self.dynamic_linear.add_module("activation_function_" + str(i + 1), nn.Sigmoid() if config['activation'] == 'Sigmoid' else nn.ReLU())
        self.net = nn.Sequential(
            self.dynamic_linear,
            nn.Linear(config['features_size'],1),
            nn.Sigmoid(),
        )
    def forward(self, x):
        # x = self.dynamic_linear(x)
        output = self.net(x)
        return output.view(-1)