import matplotlib.pyplot as plt
import matplotlib
import numpy as np
import pickle

delta_values = np.arange(0.01, 0.51, 0.01)
std_values = np.arange(0, 5.1, 0.1)

Out = pickle.load(open('beta_v_sigma.pickle', 'rb'))

matplotlib.rcParams['axes.linewidth'] = 2

plt.figure(figsize=(5, 3.5))

plt.xticks(size=10, weight='bold')
plt.yticks(size=10, weight='bold')
plt.xlim([0, 3])
plt.ylim([-0.1, 1.0])
plt.ylabel(r'$\beta$', fontsize=12)
plt.xlabel(r'$\sigma$', fontsize=12)
plt.grid(True)

plt.plot(std_values, Out[2], color='red', linewidth=1, marker='x', markersize=3, markerfacecolor="red",
                      markeredgecolor="red", label=r'DM')
plt.plot(std_values, Out[7], color='blue', linewidth=1, marker='o', markersize=3, markerfacecolor="blue",
                      markeredgecolor="blue", label=r'HPL')
plt.plot(std_values, Out[12], color='green', linestyle='solid', linewidth=2, label='HPT')
plt.plot(std_values, Out[17], color='brown', linestyle='dashed', linewidth=2, label='Obesity')

plt.show()




