import numpy as np
import matplotlib.pyplot as plt


def f_monte_carlo(e, X, Y, a):
    """
    Estimates f(e) = Pr[XY*e >= a] using Monte Carlo simulation.

    Args:
      e: Value of the parameter e.
      X: Array of samples from the first Gaussian distribution.
      Y: Array of samples from the second Gaussian distribution.
      a: Constant value.

    Returns:
      Estimated value of f(e).
    """
    return np.mean(X * Y * e >= a)


# Parameters
a = 1.0  # Example constant value
num_samples = 10000  # Number of Monte Carlo samples
e_values = np.linspace(-5, 5, 100)  # Range of e values

# Set random seed for reproducibility
np.random.seed(42)

# Generate Gaussian samples
X = np.random.randn(num_samples)
Y = np.random.randn(num_samples)


# Estimate f(e) for each e value
f_estimates = [f_monte_carlo(e, X, Y, a) for e in e_values]

# Plot the results
plt.plot(e_values, f_estimates)
plt.xlabel('e')
plt.ylabel('f(e)')

plt.grid(True)
plt.show()